/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;

public class ViewDependency {
    private Connection con;
    private String user;
    private String view;
    private DatabaseMetaData dmd;
    private LinkedList tables;
    private LinkedList columns;

    public ViewDependency(ConnectionProvider cp, String user, String view) throws SQLException {
        this.con = cp.getConnection();
        this.user = user;
        this.view = view;
        this.dmd = cp.getDatabaseMetaData();
        this.tables = new LinkedList();
        this.columns = new LinkedList();
    }

    public LinkedList getTables() {
        return this.tables;
    }

    public LinkedList getColumns() {
        return this.columns;
    }

    public void constructPK() {
        try {
            String database = this.dmd.getDatabaseProductName();
            if (database == null) {
                return;
            }
            if ((database = database.trim()).equalsIgnoreCase("Oracle")) {
                this.getOraclePKTable(this.user, this.view);
                this.getOracleViewColumns();
                return;
            }
            if (database.equalsIgnoreCase("Microsoft SQL Server")) {
                this.getMSSQLServerPKTable(this.user, this.view);
                this.getMSSQLServerViewColumns();
                return;
            }
        }
        catch (SQLException exc) {
            exc.printStackTrace();
        }
    }

    private void getOraclePKTable(String user, String view) throws SQLException {
        String query = "select OWNER, REFERENCED_OWNER, REFERENCED_NAME, REFERENCED_TYPE from ALL_DEPENDENCIES where NAME = ? AND OWNER = ?";
        PreparedStatement stmt = this.con.prepareStatement(query);
        stmt.setString(1, view);
        stmt.setString(2, user);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String type = rs.getString(4).trim();
            if (type.equalsIgnoreCase("TABLE")) {
                this.tables.add(rs.getString(3).trim());
                continue;
            }
            if (!type.equalsIgnoreCase("VIEW")) continue;
            this.getOraclePKTable(rs.getString(2), rs.getString(3));
        }
        rs.close();
        stmt.close();
    }

    private void getMSSQLServerPKTable(String user, String view) throws SQLException {
        CallableStatement cs = this.con.prepareCall("{call sp_depends(?)}");
        cs.setString(1, view);
        try {
            ResultSet rs = cs.executeQuery();
            while (rs.next()) {
                String type = rs.getString(2).trim().toLowerCase();
                String name = rs.getString(1).trim();
                int pos = name.lastIndexOf(".");
                name = name.substring(pos + 1);
                if (type.indexOf("table") != -1 && !this.tables.contains(name)) {
                    this.tables.add(name);
                    continue;
                }
                if (!type.equals("view")) continue;
                this.getMSSQLServerPKTable(user, name);
            }
            rs.close();
        }
        catch (Exception exc) {
            Object rs = null;
            return;
        }
    }

    private void getOracleViewColumns() throws SQLException {
        String text = null;
        String query = "select TEXT from ALL_VIEWS where VIEW_NAME = ?";
        PreparedStatement stmt = this.con.prepareStatement(query);
        stmt.setString(1, this.view);
        ResultSet rs = stmt.executeQuery();
        if (rs.next()) {
            text = rs.getString(1).trim();
        }
        rs.close();
        stmt.close();
        if (text == null) {
            return;
        }
        int startPos = text.indexOf(" ");
        int endPos = text.toLowerCase().indexOf("from");
        text = text.substring(startPos, endPos).trim();
        StringTokenizer st = new StringTokenizer(text, ",");
        while (st.hasMoreTokens()) {
            String colName = st.nextToken().trim();
            if (colName.startsWith("\"")) {
                colName = colName.substring(1, colName.length() - 1);
            }
            this.columns.add(colName.toLowerCase());
        }
    }

    private void getMSSQLServerViewColumns() throws SQLException {
        String text = null;
        CallableStatement cs = this.con.prepareCall("{call sp_helptext(?)}");
        cs.setString(1, this.view);
        try {
            ResultSet rs = cs.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    text = text + rs.getString(1).trim();
                }
            }
            rs.close();
            cs.close();
            if (text == null) {
                return;
            }
            int startPos = text.toLowerCase().indexOf("select") + 6;
            int endPos = text.toLowerCase().indexOf("from");
            text = text.substring(startPos, endPos).trim();
            StringTokenizer st = new StringTokenizer(text, ",");
            while (st.hasMoreTokens()) {
                String colName = st.nextToken().trim();
                if (colName.startsWith("\"")) {
                    colName = colName.substring(1, colName.length() - 1);
                }
                this.columns.add(colName.toLowerCase());
            }
        }
        catch (Exception exc) {
            Object rs = null;
            return;
        }
    }
}

