/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.SessionMap;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.TypedCollections;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ServerSideStateHelper
extends StateHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    public static final String STATEMANAGED_SERIAL_ID_KEY = ServerSideStateHelper.class.getName() + ".SerialId";
    public static final String LOGICAL_VIEW_MAP = ServerSideStateHelper.class.getName() + ".LogicalViewMap";
    protected final Integer numberOfLogicalViews = this.getIntegerConfigValue(WebConfiguration.WebContextInitParameter.NumberOfLogicalViews);
    protected final Integer numberOfViews = this.getIntegerConfigValue(WebConfiguration.WebContextInitParameter.NumberOfViews);
    protected boolean generateUniqueStateIds;
    protected final SecureRandom random;

    public ServerSideStateHelper() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        this.generateUniqueStateIds = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.GenerateUniqueServerStateIds);
        if (this.generateUniqueStateIds) {
            this.random = new SecureRandom();
            this.random.nextBytes(new byte[1]);
        } else {
            this.random = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeState(FacesContext ctx, Object state, StringBuilder stateCapture) throws IOException {
        Object id;
        Util.notNull("context", ctx);
        UIViewRoot viewRoot = ctx.getViewRoot();
        if (!viewRoot.isTransient()) {
            if (!ctx.getAttributes().containsKey("com.sun.faces.ViewStateValue")) {
                Util.notNull("state", state);
                Object[] stateToWrite = (Object[])state;
                ExternalContext externalContext = ctx.getExternalContext();
                Object sessionObj = externalContext.getSession(true);
                Map<String, Object> sessionMap = externalContext.getSessionMap();
                Object object = SessionMap.getMutex(sessionObj);
                synchronized (object) {
                    Map<String, Object[]> actualMap;
                    Map<String, Map<String, Map<String, Object[]>>> logicalMap = TypedCollections.dynamicallyCastMap((Map)sessionMap.get(LOGICAL_VIEW_MAP), String.class, Map.class);
                    if (logicalMap == null) {
                        logicalMap = Collections.synchronizedMap(new LRUMap(this.numberOfLogicalViews));
                        sessionMap.put(LOGICAL_VIEW_MAP, logicalMap);
                    }
                    Object structure = stateToWrite[0];
                    Object savedState = this.handleSaveState(stateToWrite[1]);
                    String idInLogicalMap = (String)RequestStateManager.get(ctx, "com.sun.faces.logicalViewMap");
                    if (idInLogicalMap == null) {
                        idInLogicalMap = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(ctx);
                    }
                    String idInActualMap = null;
                    if (ctx.getPartialViewContext().isPartialRequest()) {
                        idInActualMap = (String)RequestStateManager.get(ctx, "com.sun.faces.actualViewMap");
                    }
                    if (null == idInActualMap) {
                        String string = idInActualMap = this.generateUniqueStateIds ? this.createRandomId() : this.createIncrementalRequestId(ctx);
                    }
                    if ((actualMap = TypedCollections.dynamicallyCastMap(logicalMap.get(idInLogicalMap), String.class, Object[].class)) == null) {
                        actualMap = new LRUMap<String, Object[]>(this.numberOfViews);
                        logicalMap.put(idInLogicalMap, actualMap);
                    }
                    id = idInLogicalMap + ":" + idInActualMap;
                    Object[] stateArray = actualMap.get(idInActualMap);
                    if (stateArray != null) {
                        stateArray[0] = structure;
                        stateArray[1] = savedState;
                    } else {
                        actualMap.put(idInActualMap, new Object[]{structure, savedState});
                    }
                    sessionMap.put(LOGICAL_VIEW_MAP, logicalMap);
                    ctx.getAttributes().put("com.sun.faces.ViewStateValue", id);
                }
            } else {
                id = (String)ctx.getAttributes().get("com.sun.faces.ViewStateValue");
            }
        } else {
            id = "stateless";
        }
        if (stateCapture != null) {
            stateCapture.append((String)id);
        } else {
            ResponseWriter writer = ctx.getResponseWriter();
            writer.startElement("input", null);
            writer.writeAttribute("type", "hidden", null);
            writer.writeAttribute("name", RenderKitUtils.PredefinedPostbackParameter.VIEW_STATE_PARAM.getName(ctx), null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableViewStateIdRendering)) {
                String viewStateId = Util.getViewStateId(ctx);
                writer.writeAttribute("id", viewStateId, null);
            }
            writer.writeAttribute("value", id, null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState)) {
                writer.writeAttribute("autocomplete", "off", null);
            }
            writer.endElement("input");
            this.writeClientWindowField(ctx, writer);
            this.writeRenderKitIdField(ctx, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getState(FacesContext ctx, String viewId) {
        String compoundId = ServerSideStateHelper.getStateParamValue(ctx);
        if (compoundId == null) {
            return null;
        }
        if ("stateless".equals(compoundId)) {
            return "stateless";
        }
        int sep = compoundId.indexOf(58);
        if (sep == -1) {
            LOGGER.log(Level.FINE, "Unable to restore server side state for view ID {0} as no state ID is available", viewId);
            return null;
        }
        String idInLogicalMap = compoundId.substring(0, sep);
        String idInActualMap = compoundId.substring(sep + 1);
        ExternalContext externalCtx = ctx.getExternalContext();
        Object sessionObj = externalCtx.getSession(false);
        if (sessionObj == null) {
            LOGGER.log(Level.FINE, "Unable to restore server side state for view ID {0} as no session is available", viewId);
            return null;
        }
        Object object = SessionMap.getMutex(sessionObj);
        synchronized (object) {
            Map actualMap;
            Map logicalMap = (Map)externalCtx.getSessionMap().get(LOGICAL_VIEW_MAP);
            if (logicalMap != null && (actualMap = (Map)logicalMap.get(idInLogicalMap)) != null) {
                RequestStateManager.set(ctx, "com.sun.faces.logicalViewMap", idInLogicalMap);
                Object[] restoredState = new Object[2];
                Object[] state = (Object[])actualMap.get(idInActualMap);
                if (state != null) {
                    restoredState[0] = state[0];
                    restoredState[1] = state[1];
                    RequestStateManager.set(ctx, "com.sun.faces.actualViewMap", idInActualMap);
                    if (state.length == 2 && state[1] != null) {
                        restoredState[1] = this.handleRestoreState(state[1]);
                    }
                }
                return restoredState;
            }
        }
        return null;
    }

    protected Integer getIntegerConfigValue(WebConfiguration.WebContextInitParameter param) {
        String noOfViewsStr = this.webConfig.getOptionValue(param);
        Integer value = null;
        try {
            value = Integer.valueOf(noOfViewsStr);
        }
        catch (NumberFormatException nfe) {
            String defaultValue = param.getDefaultValue();
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "faces.state.server.cannot.parse.int.option", new Object[]{param.getQualifiedName(), defaultValue});
            }
            try {
                value = Integer.valueOf(defaultValue);
            }
            catch (NumberFormatException ne) {
                LOGGER.log(Level.FINEST, "Unable to convert number", ne);
            }
        }
        return value;
    }

    protected Object handleSaveState(Object state) {
        if (!this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerState)) {
            return state;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        ObjectOutputStream oas = null;
        try {
            oas = this.serialProvider.createObjectOutputStream(this.compressViewState ? new GZIPOutputStream((OutputStream)baos, 1024) : baos);
            oas.writeObject(state);
            oas.flush();
        }
        catch (Exception e) {
            throw new FacesException(e);
        }
        finally {
            if (oas != null) {
                try {
                    oas.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.FINEST, "Closing stream", ioe);
                }
            }
        }
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Object handleRestoreState(Object state) {
        if (!this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerState)) {
            return state;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream((byte[])state);){
            Object object;
            block14: {
                ObjectInputStream ois = this.serialProvider.createObjectInputStream(this.compressViewState ? new GZIPInputStream((InputStream)bais, 1024) : bais);
                try {
                    object = ois.readObject();
                    if (ois == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ois.close();
            }
            return object;
        }
        catch (Exception e) {
            throw new FacesException(e);
        }
    }

    private String createIncrementalRequestId(FacesContext ctx) {
        Map<String, Object> sessionMap = ctx.getExternalContext().getSessionMap();
        AtomicInteger idgen = (AtomicInteger)sessionMap.get(STATEMANAGED_SERIAL_ID_KEY);
        if (idgen == null) {
            idgen = new AtomicInteger(1);
        }
        sessionMap.put(STATEMANAGED_SERIAL_ID_KEY, idgen);
        return "j_id" + idgen.getAndIncrement();
    }

    private String createRandomId() {
        return Long.valueOf(this.random.nextLong()).toString();
    }

    @Override
    public boolean isStateless(FacesContext facesContext, String viewId) throws IllegalStateException {
        if (!facesContext.isPostback()) {
            throw new IllegalStateException("Cannot determine whether or not the request is stateless");
        }
        String compoundId = ServerSideStateHelper.getStateParamValue(facesContext);
        return compoundId != null && "stateless".equals(compoundId);
    }
}

