/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.glassfish.api.admin.InstanceState;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

class InstanceStateFileProcessor {
    private final Document xmlDoc;
    private final File stateFile;

    InstanceStateFileProcessor(Map<String, InstanceState> instanceStates, File xmlFile) throws IOException {
        this.stateFile = xmlFile;
        this.xmlDoc = InstanceStateFileProcessor.parse(xmlFile);
        InstanceStateFileProcessor.parseInstanceStateFile(this.xmlDoc, instanceStates);
    }

    private static Document parse(File xmlFile) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(xmlFile);
        }
        catch (SAXException se) {
            throw new IOException("Unable to parse instance state file", se);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException("Unable to parse instance state file", pce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InstanceStateFileProcessor createNew(HashMap<String, InstanceState> st, File xmlFileObject) throws IOException {
        try (BufferedWriter writer = null;){
            writer = new BufferedWriter(new FileWriter(xmlFileObject, StandardCharsets.UTF_8));
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>");
            writer.newLine();
            writer.write("<instance-state version=\"1.0\">");
            writer.newLine();
            writer.write("<gms-enabled>false</gms-enabled>");
            writer.newLine();
            for (String instanceName : st.keySet()) {
                writer.write("<instance name=\"" + instanceName + "\" state=\"" + InstanceState.StateType.NO_RESPONSE.getDescription() + "\" />");
                writer.newLine();
            }
            writer.write("</instance-state>");
            writer.newLine();
            writer.flush();
        }
        return new InstanceStateFileProcessor(st, xmlFileObject);
    }

    public void addNewServer(String name) throws Exception {
        String newState = InstanceState.StateType.NEVER_STARTED.getDescription();
        Node i = this.findNode(name);
        if (i != null) {
            this.removeInstanceNode(name);
        }
        this.addInstanceNode(name, newState);
        this.writeDoc();
    }

    private static void parseInstanceStateFile(Document xmlDoc, Map<String, InstanceState> instanceStates) {
        NodeList list = xmlDoc.getElementsByTagName("instance");
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            InstanceStateFileProcessor.parseInstanceElement(list.item(i), instanceStates);
        }
    }

    private static void parseInstanceElement(Node n, Map<String, InstanceState> instanceStates) {
        String name = null;
        String state = null;
        NamedNodeMap attrs = n.getAttributes();
        if (attrs != null) {
            name = InstanceStateFileProcessor.getNodeValue(attrs.getNamedItem("name"));
            state = InstanceStateFileProcessor.getNodeValue(attrs.getNamedItem("state"));
        }
        if (name == null) {
            return;
        }
        InstanceState newInstanceState = null;
        newInstanceState = state == null ? new InstanceState(InstanceState.StateType.NO_RESPONSE) : new InstanceState(InstanceState.StateType.makeStateType((String)state));
        NodeList list = n.getChildNodes();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            String t = list.item(i).getTextContent();
            if ("\n".equals(t)) continue;
            newInstanceState.addFailedCommands(t);
        }
        instanceStates.put(name, newInstanceState);
    }

    private static String getNodeValue(Node x) {
        return x == null ? null : x.getNodeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDoc() throws Exception {
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(this.stateFile);
            TransformerFactory transformerfactory = TransformerFactory.newInstance();
            Transformer transformer = transformerfactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource domSource = new DOMSource(this.xmlDoc);
            transformer.transform(domSource, new StreamResult(outputStream));
        }
    }

    public void updateState(String instanceName, String newState) throws Exception {
        Node instance = this.findNode(instanceName);
        if (instance == null) {
            this.addInstanceNode(instanceName, newState);
        } else {
            instance.getAttributes().getNamedItem("state").setNodeValue(newState);
        }
        this.writeDoc();
    }

    private Node findNode(String instanceName) {
        NodeList list = this.xmlDoc.getElementsByTagName("instance");
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            String name;
            Node instance = list.item(i);
            NamedNodeMap attrs = instance.getAttributes();
            if (attrs == null || !instanceName.equals(name = InstanceStateFileProcessor.getNodeValue(attrs.getNamedItem("name")))) continue;
            return instance;
        }
        return null;
    }

    public void addFailedCommand(String instanceName, String failedCmd) throws Exception {
        Node instance = this.findNode(instanceName);
        if (instance == null) {
            instance = this.addInstanceNode(instanceName, InstanceState.StateType.NO_RESPONSE.getDescription());
        }
        Text tNode = this.xmlDoc.createTextNode(failedCmd);
        Element fcNode = this.xmlDoc.createElement("failed-command");
        fcNode.appendChild(tNode);
        instance.appendChild(fcNode);
        this.writeDoc();
    }

    public void removeFailedCommands(String instanceName) throws Exception {
        Node instance = this.findNode(instanceName);
        if (instance == null) {
            return;
        }
        NodeList clist = instance.getChildNodes();
        for (int j = 0; j < clist.getLength(); ++j) {
            instance.removeChild(clist.item(j));
        }
        this.writeDoc();
    }

    public void removeInstanceNode(String instanceName) throws Exception {
        Node instance = this.findNode(instanceName);
        if (instance == null) {
            return;
        }
        NodeList clist = instance.getChildNodes();
        for (int j = 0; j < clist.getLength(); ++j) {
            instance.removeChild(clist.item(j));
        }
        Node parent = instance.getParentNode();
        parent.removeChild(instance);
        this.writeDoc();
    }

    private Node addInstanceNode(String name, String state) {
        Node parentNode = this.xmlDoc.getElementsByTagName("instance-state").item(0);
        Element insNode = this.xmlDoc.createElement("instance");
        insNode.setAttribute("name", name);
        insNode.setAttribute("state", state);
        parentNode.appendChild(insNode);
        return insNode;
    }
}

