/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.ejb;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.ejb.Container;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.api.persistence.support.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperPersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.CMPHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.ContainerHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.SunTransactionHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerFactoryImpl;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import jakarta.ejb.EJBContext;
import jakarta.ejb.EJBException;
import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EJBObject;
import jakarta.ejb.EntityContext;
import jakarta.transaction.Transaction;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.persistence.common.I18NHelper;
import org.glassfish.persistence.ejb.entitybean.container.spi.CascadeDeleteNotifier;

public class SunContainerHelper
extends SunTransactionHelper
implements ContainerHelper {
    private static final ResourceBundle messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (ClassLoader)SunContainerHelper.class.getClassLoader());
    private static Logger logger = LogHelperPersistenceManager.getLogger();

    SunContainerHelper() {
    }

    @Override
    public Object getContainer(Object info) {
        Object[] params = (Object[])info;
        String appName = (String)params[0];
        ServiceLocator habitat = Globals.getDefaultHabitat();
        ApplicationRegistry reg = (ApplicationRegistry)habitat.getService(ApplicationRegistry.class, new Annotation[0]);
        ApplicationInfo appInfo = reg.get(appName);
        Application app = (Application)appInfo.getMetaData(Application.class);
        EjbDescriptor desc = app.getEjbByName((String)params[1]);
        return ((EjbContainerUtil)habitat.getService(EjbContainerUtil.class, new Annotation[0])).getContainer(desc.getUniqueId());
    }

    @Override
    public EJBObject getEJBObject(Object pk, Object container) {
        try {
            return ((Container)container).getEJBObjectForPrimaryKey(pk);
        }
        catch (Exception ex) {
            throw new JDOFatalInternalException(ex.getMessage(), ex);
        }
    }

    @Override
    public EJBLocalObject getEJBLocalObject(Object pk, Object container) {
        try {
            return ((Container)container).getEJBLocalObjectForPrimaryKey(pk);
        }
        catch (Exception ex) {
            throw new JDOFatalInternalException(ex.getMessage(), ex);
        }
    }

    @Override
    public EJBLocalObject getEJBLocalObject(Object pk, Object container, EJBContext context) {
        EJBLocalObject rc = null;
        try {
            rc = ((Container)container).getEJBLocalObjectForPrimaryKey(pk, context);
        }
        catch (Exception ex) {
            this.processContainerException(ex);
        }
        return rc;
    }

    @Override
    public void removeByEJBLocalObject(EJBLocalObject ejb, Object container) {
        try {
            ((Container)container).removeBeanUnchecked(ejb);
        }
        catch (Exception ex) {
            this.processContainerException(ex);
        }
    }

    @Override
    public void removeByPK(Object pk, Object container) {
        try {
            ((Container)container).removeBeanUnchecked(pk);
        }
        catch (Exception ex) {
            this.processContainerException(ex);
        }
    }

    @Override
    public void assertValidLocalObject(Object o, Object container) {
        ((Container)container).assertValidLocalObject(o);
    }

    @Override
    public void assertValidRemoteObject(Object o, Object container) {
        ((Container)container).assertValidRemoteObject(o);
    }

    @Override
    public void setCascadeDeleteAfterSuperEJBRemove(EntityContext context) {
        try {
            ((CascadeDeleteNotifier)context).setCascadeDeleteAfterSuperEJBRemove(true);
        }
        catch (Exception ex) {
            this.processContainerException(ex);
        }
    }

    @Override
    public void preSelect(Object container) {
        ((Container)container).preSelect();
    }

    @Override
    public PersistenceManagerFactory getPersistenceManagerFactory(Object container) {
        PersistenceManagerFactoryImpl pmf;
        block6: {
            Object rc = null;
            pmf = null;
            ResourceReferenceDescriptor cmpResource = ((Container)container).getEjbDescriptor().getEjbBundleDescriptor().getCMPResourceReference();
            SimpleJndiName name = cmpResource.getJndiName();
            try {
                InitialContext ic = new InitialContext();
                rc = ic.lookup(name.toString());
                if (rc instanceof PersistenceManagerFactoryImpl) {
                    pmf = (PersistenceManagerFactoryImpl)rc;
                    break block6;
                }
                if (rc instanceof DataSource) {
                    pmf = new PersistenceManagerFactoryImpl();
                    pmf.setConnectionFactoryName(ConnectorsUtil.getPMJndiName((SimpleJndiName)name));
                    Iterator it = cmpResource.getProperties();
                    if (it != null) {
                        while (it.hasNext()) {
                            NameValuePairDescriptor prop = (NameValuePairDescriptor)it.next();
                            String n = prop.getName();
                            boolean value = Boolean.valueOf(prop.getValue());
                            pmf.setBooleanProperty(n, value);
                        }
                    }
                    break block6;
                }
                JDOFatalUserException e = new JDOFatalUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"ejb.jndi.unexpectedinstance", (Object[])new Object[]{name, rc.getClass().getName()}));
                logger.severe(e.toString());
                throw e;
            }
            catch (NamingException ex) {
                JDOFatalUserException e = new JDOFatalUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"ejb.jndi.lookupfailed", (Object[])new Object[]{name}), (Exception)ex);
                logger.severe(e.toString());
                throw e;
            }
        }
        return pmf;
    }

    @Override
    public int getNumericConverterPolicy(Object container) {
        return 0;
    }

    @Override
    public void beginInternalTransaction(PersistenceManager pm) {
        pm.currentTransaction().begin();
    }

    @Override
    public void commitInternalTransaction(PersistenceManager pm) {
        pm.currentTransaction().commit();
    }

    @Override
    public void rollbackInternalTransaction(PersistenceManager pm) {
        pm.currentTransaction().rollback();
    }

    @Override
    public Transaction suspendCurrentTransaction() {
        Transaction tx = null;
        try {
            tx = this.getLocalTransactionManager().suspend();
        }
        catch (Exception ex) {
            this.processContainerException(ex);
        }
        return tx;
    }

    @Override
    public void resumeCurrentTransaction(Transaction tx) {
        try {
            if (tx != null) {
                this.getLocalTransactionManager().resume(tx);
            }
        }
        catch (Exception ex) {
            this.processContainerException(ex);
        }
    }

    private void processContainerException(Exception ex) {
        if (ex instanceof EJBException) {
            throw (EJBException)ex;
        }
        if (ex instanceof IllegalArgumentException || ex instanceof IllegalStateException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof JDOException) {
            throw (JDOException)((Object)ex);
        }
        throw new EJBException(ex);
    }

    static {
        CMPHelper.registerContainerHelper(new SunContainerHelper());
    }
}

