/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import org.glassfish.web.deployment.descriptor.CookieConfigDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CookieConfigNode
extends DeploymentDescriptorNode<CookieConfigDescriptor> {
    private CookieConfigDescriptor descriptor;

    public CookieConfigDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new CookieConfigDescriptor();
        }
        return this.descriptor;
    }

    protected Map<String, String> getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("name", "setName");
        table.put("domain", "setDomain");
        table.put("path", "setPath");
        table.put("comment", "setComment");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("http-only".equals(element.getQName())) {
            this.descriptor.setHttpOnly(Boolean.parseBoolean(value));
        } else if ("secure".equals(element.getQName())) {
            this.descriptor.setSecure(Boolean.parseBoolean(value));
        } else if ("max-age".equals(element.getQName())) {
            this.descriptor.setMaxAge(Integer.parseInt(value));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, CookieConfigDescriptor descriptor) {
        Element myNode = CookieConfigNode.appendChild((Node)parent, (String)nodeName);
        if (descriptor.getName() != null && descriptor.getName().length() > 0) {
            CookieConfigNode.appendTextChild((Node)myNode, (String)"name", (String)descriptor.getName());
        }
        if (descriptor.getDomain() != null) {
            CookieConfigNode.appendTextChild((Node)myNode, (String)"domain", (String)descriptor.getDomain());
        }
        if (descriptor.getPath() != null) {
            CookieConfigNode.appendTextChild((Node)myNode, (String)"path", (String)descriptor.getPath());
        }
        if (descriptor.getComment() != null) {
            CookieConfigNode.appendTextChild((Node)myNode, (String)"comment", (String)descriptor.getComment());
        }
        CookieConfigNode.appendTextChild((Node)myNode, (String)"http-only", (String)Boolean.toString(descriptor.isHttpOnly()));
        CookieConfigNode.appendTextChild((Node)myNode, (String)"secure", (String)Boolean.toString(descriptor.isSecure()));
        CookieConfigNode.appendTextChild((Node)myNode, (String)"max-age", (String)Integer.toString(descriptor.getMaxAge()));
        return myNode;
    }
}

