/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.security.auth.realm.GroupMapper;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsManagerHolder;
import com.sun.enterprise.security.auth.realm.exceptions.BadRealmException;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchRealmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AbstractGlassFishRealmState
implements Comparable<Realm> {
    public static final String JAAS_CONTEXT_PARAM = "jaas-context";
    public static final String PARAM_GROUP_MAPPING = "group-mapping";
    private static final String PARAM_GROUPS = "assign-groups";
    private static final String GROUPS_SEP = ",";
    private static final String DEFAULT_DEF_DIG_ALGO_VAL = "SHA-256";
    private String realmName;
    private Properties contextProperties = new Properties();
    private List<String> assignGroups;
    private String defaultDigestAlgorithm;
    protected GroupMapper groupMapper;

    protected AbstractGlassFishRealmState() {
    }

    protected void init(Properties properties) throws BadRealmException, NoSuchRealmException {
        String groupMapping;
        String groupList = properties.getProperty(PARAM_GROUPS);
        if (groupList != null && groupList.length() > 0) {
            this.setProperty(PARAM_GROUPS, groupList);
            this.assignGroups = new ArrayList<String>();
            for (String group : groupList.split(GROUPS_SEP)) {
                if (this.assignGroups.contains(group)) continue;
                this.assignGroups.add(group);
            }
        }
        if ((groupMapping = properties.getProperty(PARAM_GROUP_MAPPING)) != null) {
            this.groupMapper = new GroupMapper();
            this.groupMapper.parse(groupMapping);
        }
        String defaultDigestAlgo = null;
        if (RealmsManagerHolder._getRealmsManager() != null) {
            defaultDigestAlgo = RealmsManagerHolder._getRealmsManager().getDefaultDigestAlgorithm();
        }
        this.defaultDigestAlgorithm = defaultDigestAlgo == null ? DEFAULT_DEF_DIG_ALGO_VAL : defaultDigestAlgo;
    }

    protected String[] addAssignGroups(String[] groups) {
        String[] resultGroups = groups;
        if (this.assignGroups != null && this.assignGroups.size() > 0) {
            ArrayList<String> groupList = new ArrayList<String>();
            if (groups != null && groups.length > 0) {
                for (String group : groups) {
                    groupList.add(group);
                }
            }
            for (String assignGroup : this.assignGroups) {
                if (groupList.contains(assignGroup)) continue;
                groupList.add(assignGroup);
            }
            resultGroups = groupList.toArray(new String[groupList.size()]);
        }
        return resultGroups;
    }

    protected ArrayList<String> getMappedGroupNames(String group) {
        if (this.groupMapper == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        this.groupMapper.getMappedGroups(group, result);
        return result;
    }

    public void refresh(String configName) throws BadRealmException {
    }

    public final String getName() {
        return this.realmName;
    }

    protected final void setName(String name) {
        if (this.realmName != null) {
            return;
        }
        this.realmName = name;
    }

    protected String getDefaultDigestAlgorithm() {
        return this.defaultDigestAlgorithm;
    }

    public synchronized String getProperty(String name) {
        return this.contextProperties.getProperty(name);
    }

    public synchronized void setProperty(String name, String value) {
        this.contextProperties.setProperty(name, value);
    }

    protected synchronized Properties getProperties() {
        return this.contextProperties;
    }

    public abstract String getAuthType();

    public synchronized String getJAASContext() {
        return this.contextProperties.getProperty(JAAS_CONTEXT_PARAM);
    }

    public String toString() {
        return this.realmName;
    }

    @Override
    public int compareTo(Realm otherRealm) {
        String str = otherRealm.getAuthType();
        int temp = this.getAuthType().compareTo(str);
        if (temp != 0) {
            return temp;
        }
        return this.getName().compareTo(otherRealm.getName());
    }
}

