/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli.reader.impl;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import org.glassfish.loadbalancer.admin.cli.reader.api.IdempotentUrlPatternReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.LbReaderException;
import org.glassfish.loadbalancer.admin.cli.reader.api.WebModuleReader;
import org.glassfish.loadbalancer.admin.cli.reader.impl.IdempotentUrlPatternReaderImpl;
import org.glassfish.loadbalancer.admin.cli.transform.Visitor;
import org.glassfish.loadbalancer.admin.cli.transform.WebModuleVisitor;

public class WebModuleReaderImpl
implements WebModuleReader {
    private String _name;
    private ApplicationRef _applicationRef = null;
    private Application _application = null;
    private WebBundleDescriptor _webBundleDescriptor;
    private SunWebApp _sunWebApp;

    public WebModuleReaderImpl(String name, ApplicationRef ref, Application application, WebBundleDescriptor webBundleDescriptor) {
        this._applicationRef = ref;
        this._application = application;
        this._name = name;
        this._webBundleDescriptor = webBundleDescriptor;
        this._sunWebApp = webBundleDescriptor.getSunDescriptor();
    }

    @Override
    public String getContextRoot() throws LbReaderException {
        if (this._application.getContextRoot() != null) {
            return this._application.getContextRoot();
        }
        return this._webBundleDescriptor.getContextRoot();
    }

    @Override
    public String getErrorUrl() throws LbReaderException {
        return this._sunWebApp.getAttributeValue("ErrorUrl");
    }

    @Override
    public boolean getLbEnabled() throws LbReaderException {
        return Boolean.valueOf(this._applicationRef.getLbEnabled());
    }

    @Override
    public String getDisableTimeoutInMinutes() throws LbReaderException {
        return this._applicationRef.getDisableTimeoutInMinutes();
    }

    @Override
    public IdempotentUrlPatternReader[] getIdempotentUrlPattern() throws LbReaderException {
        if (this._sunWebApp == null) {
            return null;
        }
        int len = this._sunWebApp.sizeIdempotentUrlPattern();
        if (len == 0) {
            return null;
        }
        IdempotentUrlPatternReader[] iRdrs = new IdempotentUrlPatternReader[len];
        for (int i = 0; i < len; ++i) {
            iRdrs[i] = new IdempotentUrlPatternReaderImpl(this._sunWebApp.getIdempotentUrlPattern(i));
        }
        return iRdrs;
    }

    @Override
    public void accept(Visitor v) throws Exception {
        if (v instanceof WebModuleVisitor) {
            WebModuleVisitor wv = (WebModuleVisitor)v;
            wv.visit(this);
        }
    }
}

