/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MappedSuperclassTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredField;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethod;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;

public abstract class AttributeImpl<X, T>
implements Attribute<X, T>,
Serializable {
    private ManagedTypeImpl<X> managedType;
    private DatabaseMapping mapping;

    protected AttributeImpl(ManagedTypeImpl<X> managedType, DatabaseMapping mapping) {
        this.mapping = mapping;
        this.managedType = managedType;
    }

    public ManagedType<X> getDeclaringType() {
        return this.getManagedTypeImpl();
    }

    protected ClassDescriptor getDescriptor() {
        return this.getManagedTypeImpl().getDescriptor();
    }

    public Member getJavaMember() {
        AttributeAccessor accessor = this.getMapping().getAttributeAccessor();
        if (accessor.isMethodAttributeAccessor()) {
            Method aMethod = ((MethodAttributeAccessor)accessor).getGetMethod();
            if (null == aMethod) {
                String getMethodName = null;
                try {
                    getMethodName = ((MethodAttributeAccessor)this.mapping.getAttributeAccessor()).getGetMethodName();
                    aMethod = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(this.getManagedTypeImpl().getJavaType(), getMethodName, null)) : PrivilegedAccessHelper.getDeclaredMethod(this.getManagedTypeImpl().getJavaType(), (String)getMethodName, null);
                }
                catch (PrivilegedActionException privilegedActionException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return aMethod;
        }
        Member aMember = ((InstanceVariableAttributeAccessor)accessor).getAttributeField();
        if (null == aMember) {
            AttributeImpl inheritingTypeMember;
            if (this.getManagedTypeImpl().isMappedSuperclass() && null != (inheritingTypeMember = ((MappedSuperclassTypeImpl)this.getManagedTypeImpl()).getMemberFromInheritingType(this.mapping.getAttributeName()))) {
                aMember = ((InstanceVariableAttributeAccessor)inheritingTypeMember.getMapping().getAttributeAccessor()).getAttributeField();
            }
            if (null == aMember) {
                try {
                    aMember = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Member)AccessController.doPrivileged(new PrivilegedGetDeclaredField(this.getManagedTypeImpl().getJavaType(), this.mapping.getAttributeName(), false)) : PrivilegedAccessHelper.getDeclaredField(this.getManagedTypeImpl().getJavaType(), (String)this.mapping.getAttributeName(), (boolean)false);
                }
                catch (PrivilegedActionException privilegedActionException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
        if (null == aMember) {
            AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_attribute_getmember_is_null", (Object)this, this.getManagedTypeImpl(), (Object)this.getDescriptor());
        }
        return aMember;
    }

    public abstract Class<T> getJavaType();

    public ManagedTypeImpl<X> getManagedTypeImpl() {
        return this.managedType;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected MetamodelImpl getMetamodel() {
        return this.managedType.getMetamodel();
    }

    public String getName() {
        return this.getMapping().getAttributeName();
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        if (this.mapping.isAbstractDirectMapping()) {
            return Attribute.PersistentAttributeType.BASIC;
        }
        if (this.mapping.isAggregateObjectMapping()) {
            return Attribute.PersistentAttributeType.EMBEDDED;
        }
        if (this.mapping.isOneToManyMapping()) {
            return Attribute.PersistentAttributeType.ONE_TO_MANY;
        }
        if (this.mapping.isManyToManyMapping()) {
            if (((ManyToManyMapping)this.mapping).isDefinedAsOneToManyMapping()) {
                return Attribute.PersistentAttributeType.ONE_TO_MANY;
            }
            return Attribute.PersistentAttributeType.MANY_TO_MANY;
        }
        if (this.mapping.isManyToOneMapping()) {
            return Attribute.PersistentAttributeType.MANY_TO_ONE;
        }
        if (this.mapping.isOneToOneMapping()) {
            return Attribute.PersistentAttributeType.ONE_TO_ONE;
        }
        return Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
    }

    public boolean isAssociation() {
        return this.getMapping().isForeignReferenceMapping() && !this.getMapping().isDirectCollectionMapping() && !this.getMapping().isAggregateCollectionMapping();
    }

    public boolean isCollection() {
        return this.getMapping().isCollectionMapping();
    }

    public abstract boolean isPlural();
}

