/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.io.disk.VRFileRAF;
import com.sun.messaging.jmq.io.disk.VRFileWarning;
import com.sun.messaging.jmq.io.disk.VRecordRAF;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.MessageInfo;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.RandomAccessStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

class DstMsgStore
extends RandomAccessStore {
    BrokerConfig config = Globals.getConfig();
    static final String USE_FILE_CHANNEL_PROP = "imq.persist.file.message.use_file_channel";
    static final boolean DEFAULT_USE_FILE_CHANNEL = false;
    static String VRFILE_NAME = "vrfile";
    static boolean useFileChannel = Globals.getConfig().getBooleanProperty("imq.persist.file.message.use_file_channel", false);
    DestinationUID myDestination = null;
    private ConcurrentHashMap messageMap = new ConcurrentHashMap(1000);
    private AtomicBoolean loaded = new AtomicBoolean(false);
    protected float growthFactor = this.config.getPercentageProperty("imq.persist.file.message.vrfile.growth_factor", 0.5f);
    protected long threshold = this.config.getLongProperty("imq.persist.file.message.vrfile.threshold", 0L);
    protected float thresholdFactor = this.config.getPercentageProperty("imq.persist.file.message.vrfile.threshold_factor", 0.0f);
    private static FilenameFilter vrfileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.equals(VRFILE_NAME);
        }
    };
    private static Enumeration emptyEnum = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };
    private int msgCount = 0;
    private long byteCount = 0L;
    private Object countLock = new Object();
    private VRFileRAF vrfile = null;
    int maxRecordSize = 0;

    DstMsgStore(MsgStore p, DestinationUID dst, File dir) throws BrokerException {
        this(p, dst, dir, false);
    }

    DstMsgStore(MsgStore p, DestinationUID dst, File dir, boolean load) throws BrokerException {
        super(dir, p.msgfdlimit, p.poollimit, p.cleanratio);
        this.myDestination = dst;
        try {
            long fsize = p.initialFileSize.getBytes();
            if (fsize > 0L) {
                this.maxRecordSize = (int)p.maxRecordSize.getBytes();
                this.vrfile = new VRFileRAF(new File(dir, VRFILE_NAME), fsize, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
                this.vrfile.setBlockSize(p.blockSize);
                try {
                    this.vrfile.setGrowthFactor(this.growthFactor);
                }
                catch (IllegalArgumentException iiEx) {
                    this.vrfile.setGrowthFactor(0.5f);
                    this.growthFactor = 0.5f;
                    this.logger.log(8, "Invalid growth_factor value. Using default value of 50%.");
                }
                try {
                    this.vrfile.setThreshold(this.threshold);
                }
                catch (IllegalArgumentException iiEx) {
                    this.vrfile.setThreshold(0L);
                    this.threshold = 0L;
                    this.logger.log(8, "Invalid threshold value. Using default value of 0.");
                }
                try {
                    this.vrfile.setThresholdFactor(this.thresholdFactor);
                }
                catch (IllegalArgumentException iiEx) {
                    this.vrfile.setThresholdFactor(0.0f);
                    this.thresholdFactor = 0.0f;
                    this.logger.log(8, "Invalid threshold_factor value. Using default value of 0%.");
                }
                try {
                    if (this.threshold != 0L || this.thresholdFactor != 0.0f) {
                        this.vrfile.checkGrowthFactorSanity();
                    }
                }
                catch (IllegalStateException isEx) {
                    String exMsg = isEx.getMessage();
                    this.logger.log(8, exMsg);
                }
                try {
                    this.vrfile.open();
                }
                catch (VRFileWarning e) {
                    this.logger.log(16, "possible data loss for " + String.valueOf(this.myDestination), e);
                }
            }
            this.initCounts();
        }
        catch (Throwable t) {
            this.logger.log(32, "B4147", dir, dst, t);
            throw new BrokerException(this.br.getString("B4147", dir, dst), t);
        }
        if (load) {
            this.loadMessages();
        }
    }

    public HashMap getStorageInfo() throws BrokerException {
        if (this.vrfile == null) {
            return new HashMap();
        }
        HashMap<String, Number> info = new HashMap<String, Number>(3);
        long used = this.vrfile.getBytesUsed();
        long free = this.vrfile.getBytesFree();
        info.put("diskUsed", used);
        info.put("diskReserved", used + free);
        info.put("diskUtilizationRatio", (int)(this.vrfile.getUtilizationRatio() * 100.0f));
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compact() throws BrokerException {
        if (this.vrfile == null) {
            return;
        }
        VRFileRAF vRFileRAF = this.vrfile;
        synchronized (vRFileRAF) {
            try {
                this.vrfile.close();
                try {
                    this.vrfile.compact();
                }
                catch (VRFileWarning e) {
                    this.logger.log(16, "possible data loss for " + String.valueOf(this.myDestination), e);
                }
                try {
                    this.vrfile.open();
                }
                catch (VRFileWarning e) {
                    this.logger.log(16, "possible data loss for " + String.valueOf(this.myDestination), e);
                }
                this.messageMap.clear();
                Iterator itr = this.vrfile.getRecords().iterator();
                MsgEnumeration e = new MsgEnumeration(this, itr, emptyEnum);
                while (e.hasMoreElements()) {
                    e.nextElement();
                }
            }
            catch (IOException e) {
                throw new BrokerException("Failed to compact file: " + String.valueOf(this.vrfile.getFile()), e);
            }
        }
    }

    MessageInfo storeMessage(Packet message, ConsumerUID[] iids, int[] states, boolean sync) throws IOException, BrokerException {
        SysMessageID id = message.getSysMessageID();
        if (this.messageMap.containsKey(id)) {
            this.logger.log(32, "B3008", (Object)id, this.myDestination);
            throw new BrokerException(this.br.getString("B3008", id, this.myDestination));
        }
        try {
            int msgsize = message.getPacketSize();
            MessageInfo info = null;
            info = this.vrfile != null && (this.maxRecordSize == 0 || msgsize < this.maxRecordSize) ? new MessageInfo(this, this.vrfile, message, iids, states, sync) : new MessageInfo(this, message, iids, states, sync);
            this.messageMap.put(info.getID(), info);
            this.incrMsgCount(msgsize);
            return info;
        }
        catch (IOException e) {
            this.logger.log(32, "B4004", (Object)id.toString(), (Throwable)e);
            throw e;
        }
    }

    void removeMessage(SysMessageID id, boolean sync) throws IOException, BrokerException {
        MessageInfo oldmsg = (MessageInfo)this.messageMap.remove(id);
        if (oldmsg == null) {
            this.logger.log(32, "B3007", (Object)id, this.myDestination);
            throw new BrokerException(this.br.getString("B3007", id, this.myDestination));
        }
        oldmsg.free(sync);
        this.decrMsgCount(oldmsg.getSize());
    }

    void removeAllMessages(boolean sync) throws IOException, BrokerException {
        if (this.vrfile != null) {
            this.vrfile.clear(false);
        }
        this.removeAllData(sync);
        this.messageMap.clear();
        this.clearCounts();
    }

    void releaseMessageDir(boolean sync) throws IOException {
        if (this.vrfile != null) {
            this.vrfile.clear(false);
            this.vrfile.close();
            this.vrfile = null;
        }
        this.reset(true);
        super.close(false);
        this.messageMap.clear();
        this.clearCounts();
    }

    Enumeration messageEnumeration() {
        if (this.loaded.get()) {
            return new MsgEnumeration(this, this.getMessageIterator());
        }
        Iterator recitr = null;
        if (this.vrfile != null) {
            recitr = this.vrfile.getRecords().iterator();
        }
        return new MsgEnumeration(this, recitr, this.getFileEnumeration());
    }

    int getMessageCount() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:getMessageCount()");
        }
        return this.msgCount;
    }

    long getByteCount() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:getByteCount()");
        }
        return this.byteCount;
    }

    @Override
    protected void close(boolean cleanup) {
        if (this.vrfile != null) {
            this.vrfile.close();
        }
        super.close(cleanup);
        this.messageMap.clear();
    }

    VRFileRAF getVRFile() {
        return this.vrfile;
    }

    private void loadMessages() throws BrokerException {
        Enumeration e = this.messageEnumeration();
        while (e.hasMoreElements()) {
            e.nextElement();
        }
        this.logger.log(4, "loaded " + this.messageMap.size() + " messages");
    }

    MessageInfo getMessageInfo(SysMessageID mid) throws BrokerException {
        MessageInfo info = (MessageInfo)this.messageMap.get(mid);
        if (info == null) {
            String emsg = this.br.getKString("B3007", mid, this.myDestination);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        return info;
    }

    @Override
    Object parseData(byte[] data, byte[] attachment) throws IOException {
        MessageInfo minfo = new MessageInfo(this, data, attachment);
        SysMessageID mid = minfo.getID();
        this.messageMap.put(mid, minfo);
        return mid;
    }

    @Override
    FilenameFilter getFilenameFilter() {
        return vrfileFilter;
    }

    private void cacheMessageInfo(MessageInfo minfo) {
        this.messageMap.put(minfo.getID(), minfo);
    }

    private Iterator getMessageIterator() {
        return ((ConcurrentHashMap.KeySetView)this.messageMap.keySet()).iterator();
    }

    private void setLoadedFlag(boolean flag) {
        this.loaded.set(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrMsgCount(int msgSize) throws BrokerException {
        Object object = this.countLock;
        synchronized (object) {
            ++this.msgCount;
            this.byteCount += (long)msgSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrMsgCount(int msgSize) throws BrokerException {
        Object object = this.countLock;
        synchronized (object) {
            --this.msgCount;
            this.byteCount -= (long)msgSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCounts() {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:clearCounts for " + String.valueOf(this.myDestination));
        }
        Object object = this.countLock;
        synchronized (object) {
            this.msgCount = 0;
            this.byteCount = 0L;
        }
    }

    private void initCounts() throws BrokerException {
        if (this.vrfile != null) {
            Set msgs = this.vrfile.getRecords();
            for (VRecordRAF record : msgs) {
                short cookie = record.getCookie();
                if (cookie == -1 || cookie != 0) {
                    String warning = String.valueOf(this.myDestination) + ": found a corrupted message at vrecord(" + String.valueOf(record) + "), a message might be lost";
                    this.logger.log(16, warning);
                    try {
                        this.vrfile.free(record);
                    }
                    catch (IOException e) {
                        this.logger.log(32, "Failed to free the corrupted vrecord: " + String.valueOf(e));
                    }
                    continue;
                }
                try {
                    ++this.msgCount;
                    this.byteCount += (long)record.readInt();
                }
                catch (Throwable t) {
                    this.logger.log(32, "B4148", (Object)this.vrfile.getFile(), t);
                    throw new BrokerException(this.br.getString("B4148", this.vrfile.getFile()), t);
                }
            }
        }
        long[] cnts = this.initCountsFromIndividualFiles();
        this.msgCount += (int)cnts[0];
        this.byteCount += cnts[1];
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore: initialized msg count=" + this.msgCount + "; byte count = " + this.byteCount);
        }
    }

    Hashtable getDebugState() {
        int numInVrfile = 0;
        if (this.vrfile != null) {
            numInVrfile = this.vrfile.getNRecords();
        }
        int numInFiles = this.msgCount - numInVrfile;
        Hashtable<CallSite, String> t = new Hashtable<CallSite, String>();
        t.put((CallSite)((Object)(String.valueOf(this.myDestination) + ":messages in vrfile")), String.valueOf(numInVrfile));
        t.put((CallSite)((Object)(String.valueOf(this.myDestination) + ":messages in its own file")), String.valueOf(numInFiles));
        return t;
    }

    void storeInterestStates(SysMessageID mid, ConsumerUID[] iids, int[] states, boolean sync) throws IOException, BrokerException {
        this.getMessageInfo(mid).storeStates(iids, states, sync);
    }

    void updateInterestState(SysMessageID mid, ConsumerUID iid, int state, boolean sync) throws IOException, BrokerException {
        this.getMessageInfo(mid).updateState(iid, state, sync);
    }

    boolean containsMsg(SysMessageID mid) {
        return this.messageMap.containsKey(mid);
    }

    Packet getMessage(SysMessageID mid) throws IOException, BrokerException {
        MessageInfo msginfo = (MessageInfo)this.messageMap.get(mid);
        if (msginfo == null) {
            String emsg = this.br.getKString("B3007", mid, this.myDestination);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        return msginfo.getMessage();
    }

    void sync() throws BrokerException {
        try {
            if (Store.getDEBUG_SYNC()) {
                this.logger.log(4, "sync called on " + String.valueOf(this.myDestination));
            }
            this.vrfile.force();
        }
        catch (IOException e) {
            throw new BrokerException("Failed to synchronize data to disk for file: " + String.valueOf(this.vrfile), e);
        }
    }

    private static class MsgEnumeration
    implements Enumeration {
        DstMsgStore parent = null;
        Iterator itr = null;
        Iterator recitr = null;
        Enumeration msgEnum = null;
        Logger logger = Globals.getLogger();
        BrokerResources br = Globals.getBrokerResources();
        Object objToReturn = null;

        MsgEnumeration(DstMsgStore p, Iterator i) {
            this.parent = p;
            this.itr = i;
        }

        MsgEnumeration(DstMsgStore p, Iterator i, Enumeration e) {
            this.parent = p;
            this.recitr = i;
            this.msgEnum = e;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.itr != null) {
                if (this.itr.hasNext()) {
                    this.objToReturn = this.itr.next();
                    return true;
                }
                return false;
            }
            if (this.recitr != null) {
                while (this.recitr.hasNext()) {
                    try {
                        MessageInfo minfo = new MessageInfo(this.parent, (VRecordRAF)this.recitr.next());
                        this.objToReturn = minfo.getMessage();
                        this.parent.cacheMessageInfo(minfo);
                        return true;
                    }
                    catch (IOException e) {
                        this.logger.log(32, "B4143", (Object)this.parent.myDestination, (Throwable)e);
                    }
                }
            }
            if (this.msgEnum.hasMoreElements()) {
                this.objToReturn = this.msgEnum.nextElement();
                return true;
            }
            this.parent.setLoadedFlag(true);
            return false;
        }

        public Object nextElement() {
            if (this.objToReturn != null) {
                Object result = null;
                Object object = this.objToReturn;
                if (object instanceof SysMessageID) {
                    SysMessageID iD = (SysMessageID)object;
                    try {
                        result = this.parent.getMessage(iD);
                    }
                    catch (BrokerException | IOException e) {
                        this.logger.log(32, "B4005", this.objToReturn, this.parent.myDestination, e);
                        throw new NoSuchElementException();
                    }
                } else {
                    result = this.objToReturn;
                }
                this.objToReturn = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

