/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnectionFactoryImpl;
import com.sun.gjc.spi.ManagedConnectionImpl;
import com.sun.gjc.spi.base.AbstractDataSource;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.util.SecurityUtils;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConfigProperty;
import jakarta.resource.spi.ConnectionDefinition;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ResourceAllocationException;
import jakarta.resource.spi.security.PasswordCredential;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

@ConnectionDefinition(connectionFactory=DataSource.class, connectionFactoryImpl=AbstractDataSource.class, connection=Connection.class, connectionImpl=ConnectionHolder.class)
public class XAManagedConnectionFactory
extends ManagedConnectionFactoryImpl {
    private transient XADataSource xaDataSourceObj;
    private static Logger _logger = LogDomains.getLogger(XAManagedConnectionFactory.class, (String)"jakarta.enterprise.resource.resourceadapter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        this.logFine("In createManagedConnection");
        PasswordCredential passwordCredential = SecurityUtils.getPasswordCredential(this, subject, connectionRequestInfo);
        XADataSource dataSource = this.getDataSource();
        XAConnection xaConnection = null;
        ManagedConnectionImpl managedConnection = null;
        try {
            xaConnection = this.isEqual(passwordCredential, this.getUser(), this.getPassword()) ? dataSource.getXAConnection() : dataSource.getXAConnection(passwordCredential.getUserName(), new String(passwordCredential.getPassword()));
        }
        catch (SQLException sqle) {
            _logger.log(Level.FINE, "jdbc.exc_create_xa_conn", sqle);
            StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);
            String msg = sm.getString("jdbc.cannot_allocate_connection", (Object)sqle.getMessage());
            throw new ResourceAllocationException(msg, (Throwable)sqle);
        }
        try {
            managedConnection = this.constructManagedConnection(xaConnection, null, passwordCredential, this);
            managedConnection.initializeConnectionType(2);
            this.validateAndSetIsolation(managedConnection);
        }
        finally {
            if (managedConnection == null && xaConnection != null) {
                try {
                    xaConnection.close();
                }
                catch (SQLException e) {
                    _logger.log(Level.FINEST, "Exception while closing connection : createManagedConnection" + String.valueOf(xaConnection));
                }
            }
        }
        return managedConnection;
    }

    @Override
    public XADataSource getDataSource() throws ResourceException {
        if (this.xaDataSourceObj == null) {
            try {
                this.xaDataSourceObj = (XADataSource)super.getDataSource();
            }
            catch (ClassCastException cce) {
                _logger.log(Level.SEVERE, "jdbc.exc_cce_XA", cce);
                throw new ResourceException(cce.getMessage());
            }
        }
        return this.xaDataSourceObj;
    }

    @Override
    @ConfigProperty(type=String.class, defaultValue="org.apache.derby.jdbc.ClientXADataSource")
    public void setClassName(String className) {
        this.spec.setDetail(20, className);
    }

    public void setMaxStatements(String maxStmts) {
        this.spec.setDetail(13, maxStmts);
    }

    public String getMaxStatements() {
        return this.spec.getDetail(13);
    }

    public void setInitialPoolSize(String initPoolSz) {
        this.spec.setDetail(14, initPoolSz);
    }

    public String getInitialPoolSize() {
        return this.spec.getDetail(14);
    }

    public void setMinPoolSize(String minPoolSz) {
        this.spec.setDetail(15, minPoolSz);
    }

    public String getMinPoolSize() {
        return this.spec.getDetail(15);
    }

    public void setMaxPoolSize(String maxPoolSz) {
        this.spec.setDetail(16, maxPoolSz);
    }

    public String getMaxPoolSize() {
        return this.spec.getDetail(16);
    }

    public void setMaxIdleTime(String maxIdleTime) {
        this.spec.setDetail(17, maxIdleTime);
    }

    public String getMaxIdleTime() {
        return this.spec.getDetail(17);
    }

    public void setPropertyCycle(String propCycle) {
        this.spec.setDetail(18, propCycle);
    }

    public String getPropertyCycle() {
        return this.spec.getDetail(18);
    }

    @Override
    public boolean equals(Object other) {
        this.logFine("In equals");
        if (other instanceof XAManagedConnectionFactory) {
            XAManagedConnectionFactory otherMCF = (XAManagedConnectionFactory)other;
            return this.spec.equals(otherMCF.spec);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 217 + this.spec.hashCode();
    }
}

