/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout;

import com.sun.jsftemplating.el.PageSessionResolver;
import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.StateManagerUtil;
import com.sun.jsftemplating.layout.ViewRootUtil;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutComposition;
import com.sun.jsftemplating.layout.descriptors.LayoutDefine;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutFacet;
import com.sun.jsftemplating.layout.descriptors.LayoutInsert;
import com.sun.jsftemplating.layout.descriptors.Resource;
import com.sun.jsftemplating.util.LogUtil;
import com.sun.jsftemplating.util.SimplePatternMatcher;
import com.sun.jsftemplating.util.TypeConversion;
import com.sun.jsftemplating.util.TypeConverter;
import com.sun.jsftemplating.util.UIComponentTypeConversion;
import com.sun.jsftemplating.util.fileStreamer.FacesStreamerContext;
import com.sun.jsftemplating.util.fileStreamer.FileStreamer;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.StateManager;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class LayoutViewHandler
extends ViewHandler {
    public static final String AJAX_REQ_KEY = "ajaxReq";
    public static final String RESTORE_VIEW_ID = "_resViewID";
    public static final String DEFAULT_RESOURCE_PREFIX = "/resource";
    public static final String RESOURCE_PREFIX = "com.sun.jsftemplating.RESOURCE_PREFIX";
    public static final String ENCODING_TYPE = "com.sun.jsftemplating.ENCODING";
    static final String AJAX_REQ_TARGET_KEY = "_ajaxReqTarget";
    private static final String VIEW_MAPPINGS = "com.sun.jsftemplating.VIEW_MAPPINGS";
    private static final TypeConversion UICOMPONENT_TYPE_CONVERSION = new UIComponentTypeConversion();
    private final ViewHandler oldViewHandler;
    private Set<String> resourcePrefix;
    private Collection<SimplePatternMatcher> viewMappings;

    public LayoutViewHandler(ViewHandler oldViewHandler) {
        this.oldViewHandler = oldViewHandler;
        LayoutDefinitionManager.clearGlobalComponentTypes(null);
        LayoutDefinitionManager.clearGlobalHandlerDefinitions(null);
        LayoutDefinitionManager.clearGlobalResources(null);
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        LayoutDefinition layoutDefinition;
        String resourcePath = this.getResourcePath(viewId);
        if (resourcePath != null) {
            return LayoutViewHandler.serveResource(facesContext, resourcePath);
        }
        if (!this.isMappedView(viewId)) {
            return this.oldViewHandler.createView(facesContext, viewId);
        }
        Locale locale = null;
        String renderKitId = null;
        if (facesContext.getViewRoot() != null) {
            UIViewRoot oldViewRoot = facesContext.getViewRoot();
            LayoutDefinition oldLayoutDefinition = ViewRootUtil.getLayoutDefinition(oldViewRoot);
            if (oldLayoutDefinition != null && oldViewRoot.getViewId().equals(viewId)) {
                oldLayoutDefinition.setInitPageExecuted(facesContext, Boolean.FALSE);
            }
            locale = facesContext.getViewRoot().getLocale();
            renderKitId = facesContext.getViewRoot().getRenderKitId();
        }
        UIViewRoot viewRoot = (UIViewRoot)facesContext.getApplication().createComponent("jakarta.faces.ViewRoot");
        viewRoot.setViewId(viewId);
        ViewRootUtil.setLayoutDefinitionKey(viewRoot, viewId);
        if (locale == null) {
            locale = this.calculateLocale(facesContext);
        }
        viewRoot.setLocale(locale);
        if (renderKitId == null) {
            renderKitId = this.calculateRenderKitId(facesContext);
        }
        viewRoot.setRenderKitId(renderKitId);
        UIViewRoot currentViewRoot = facesContext.getViewRoot();
        facesContext.setViewRoot(viewRoot);
        try {
            layoutDefinition = ViewRootUtil.getLayoutDefinition(viewRoot);
        }
        catch (LayoutDefinitionException ex) {
            if (LogUtil.configEnabled()) {
                LogUtil.config("JSFT0005", viewId);
                if (LogUtil.finestEnabled()) {
                    LogUtil.finest("File (" + viewId + ") not found!", ex);
                }
            }
            if (currentViewRoot != null) {
                facesContext.setViewRoot(currentViewRoot);
            }
            return this.oldViewHandler.createView(facesContext, viewId);
        }
        catch (RuntimeException ex) {
            if (currentViewRoot != null) {
                facesContext.setViewRoot(currentViewRoot);
            }
            throw ex;
        }
        viewRoot = facesContext.getViewRoot();
        if (layoutDefinition != null && !facesContext.getResponseComplete()) {
            for (Resource resource : layoutDefinition.getResources()) {
                resource.getFactory().getResource(facesContext, resource);
            }
            if (LayoutDefinitionManager.isDebug(facesContext)) {
                LayoutViewHandler.getClientIdMap(facesContext).clear();
            }
            LayoutViewHandler.buildUIComponentTree(facesContext, (UIComponent)viewRoot, layoutDefinition);
        }
        if (currentViewRoot != null) {
            facesContext.setViewRoot(currentViewRoot);
        }
        return viewRoot;
    }

    private boolean isMappedView(String viewId) {
        if (viewId == null) {
            return false;
        }
        if (this.viewMappings == null) {
            String initParam = (String)FacesContext.getCurrentInstance().getExternalContext().getInitParameterMap().get(VIEW_MAPPINGS);
            this.viewMappings = SimplePatternMatcher.parseMultiPatternString(initParam, ";");
        }
        if (this.viewMappings.isEmpty()) {
            return true;
        }
        for (SimplePatternMatcher mapping : this.viewMappings) {
            if (!mapping.matches(viewId)) continue;
            return true;
        }
        return false;
    }

    public static UIViewRoot serveResource(FacesContext facesContext, String resourcePath) {
        UIViewRoot viewRoot;
        block11: {
            facesContext.responseComplete();
            viewRoot = new UIViewRoot();
            viewRoot.setRenderKitId("dummy");
            FacesStreamerContext facesStreamerContext = new FacesStreamerContext(facesContext);
            facesStreamerContext.setAttribute("filePath", resourcePath);
            Object response = facesContext.getExternalContext().getResponse();
            HttpServletResponse httpServletResponse = null;
            if (response instanceof HttpServletResponse) {
                httpServletResponse = (HttpServletResponse)response;
                long lastModified = facesStreamerContext.getContentSource().getLastModified(facesStreamerContext);
                if (lastModified != -1L) {
                    long ifModifiedSince = ((HttpServletRequest)facesContext.getExternalContext().getRequest()).getDateHeader("If-Modified-Since");
                    if (ifModifiedSince < lastModified / 1000L * 1000L) {
                        httpServletResponse.setDateHeader("Last-Modified", lastModified);
                    } else {
                        httpServletResponse.setStatus(304);
                        return viewRoot;
                    }
                }
            }
            try {
                FileStreamer.getFileStreamer(facesContext).streamContent(facesStreamerContext);
            }
            catch (FileNotFoundException ex) {
                if (LogUtil.infoEnabled()) {
                    LogUtil.info("JSFT0004", resourcePath);
                }
                if (httpServletResponse != null) {
                    try {
                        httpServletResponse.sendError(404);
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ex) {
                if (!LogUtil.infoEnabled()) break block11;
                LogUtil.info("JSFT0004", resourcePath);
                if (!LogUtil.fineEnabled()) break block11;
                LogUtil.fine("Resource (" + resourcePath + ") not available!", ex);
            }
        }
        return viewRoot;
    }

    public static String getEncoding(FacesContext facesContext) {
        if (facesContext == null) {
            return null;
        }
        String encodingType = null;
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Map<String, Serializable> pageSession = PageSessionResolver.getPageSession(facesContext, viewRoot);
        if (pageSession != null) {
            encodingType = (String)((Object)pageSession.get(ENCODING_TYPE));
        }
        if (encodingType == null || encodingType.isEmpty()) {
            encodingType = facesContext.getExternalContext().getInitParameter(ENCODING_TYPE);
        }
        if (encodingType == null || encodingType.isEmpty()) {
            ExternalContext externalContext = facesContext.getExternalContext();
            try {
                ServletRequest request = (ServletRequest)externalContext.getRequest();
                encodingType = request.getCharacterEncoding();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (encodingType == null || encodingType.isEmpty()) {
                encodingType = StandardCharsets.UTF_8.name();
            }
        }
        return encodingType;
    }

    public String getResourcePath(String viewId) {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        String servletPath = externalContext.getRequestServletPath();
        for (String resourcePrefix : this.getResourcePrefixes()) {
            if (!servletPath.equals(resourcePrefix)) continue;
            return externalContext.getRequestPathInfo();
        }
        return null;
    }

    public Set<String> getResourcePrefixes() {
        if (this.resourcePrefix == null) {
            HashSet<String> prefixes = new HashSet<String>();
            String initParam = (String)FacesContext.getCurrentInstance().getExternalContext().getInitParameterMap().get(RESOURCE_PREFIX);
            if (initParam != null) {
                for (String prefix : initParam.split(",")) {
                    prefixes.add(prefix.trim());
                }
            }
            prefixes.add(DEFAULT_RESOURCE_PREFIX);
            this.resourcePrefix = prefixes;
        }
        return this.resourcePrefix;
    }

    public void setResourcePrefixes(Set<String> prefixes) {
        this.resourcePrefix = prefixes;
    }

    public static void buildUIComponentTree(FacesContext facesContext, UIComponent parentComponent, LayoutElement layoutElement) {
        for (LayoutElement childLayoutElement : layoutElement.getChildLayoutElements()) {
            if (childLayoutElement instanceof LayoutFacet) {
                if (((LayoutFacet)childLayoutElement).isRendered()) continue;
                LayoutViewHandler.buildUIComponentTree(facesContext, parentComponent, childLayoutElement);
                continue;
            }
            if (childLayoutElement instanceof LayoutComposition) {
                LayoutComposition layoutComposition = (LayoutComposition)childLayoutElement;
                String template = layoutComposition.getTemplate();
                if (template != null) {
                    block14: {
                        LayoutComposition.push(facesContext, childLayoutElement);
                        try {
                            LayoutViewHandler.buildUIComponentTree(facesContext, parentComponent, LayoutDefinitionManager.getLayoutDefinition(facesContext, template));
                        }
                        catch (LayoutDefinitionException ex) {
                            if (!((LayoutComposition)childLayoutElement).isRequired()) break block14;
                            throw ex;
                        }
                    }
                    LayoutComposition.pop(facesContext);
                    continue;
                }
                LayoutViewHandler.buildUIComponentTree(facesContext, parentComponent, childLayoutElement);
                continue;
            }
            if (childLayoutElement instanceof LayoutInsert) {
                Stack<LayoutElement> compositionStack = LayoutComposition.getCompositionStack(facesContext);
                if (compositionStack.empty()) {
                    throw new IllegalArgumentException("'ui:insert' encountered, however, no 'ui:composition' was used!");
                }
                Object insertName = ((LayoutInsert)childLayoutElement).getName();
                if (insertName == null) {
                    LayoutViewHandler.buildUIComponentTree(facesContext, parentComponent, (LayoutElement)compositionStack.get(0));
                    continue;
                }
                LayoutDefine layoutDefine = LayoutInsert.findLayoutDefine(facesContext, parentComponent, compositionStack, (String)(insertName = "" + ((LayoutInsert)childLayoutElement).resolveValue(facesContext, parentComponent, insertName)));
                if (layoutDefine == null) {
                    LayoutViewHandler.buildUIComponentTree(facesContext, parentComponent, childLayoutElement);
                    continue;
                }
                LayoutViewHandler.buildUIComponentTree(facesContext, parentComponent, layoutDefine);
                continue;
            }
            if (childLayoutElement instanceof LayoutComponent) {
                UIComponent childComponent = ((LayoutComponent)childLayoutElement).getChild(facesContext, parentComponent);
                if (LayoutDefinitionManager.isDebug(facesContext)) {
                    String clientId;
                    Map<String, String> clientIdMap = LayoutViewHandler.getClientIdMap(facesContext);
                    if (clientIdMap.containsKey(clientId = childComponent.getClientId(facesContext))) {
                        if (!((LayoutComponent)childLayoutElement).containsOption("skipIdCheck") && LogUtil.warningEnabled()) {
                            LogUtil.warning("JSFT0011", clientId);
                        }
                        clientIdMap.clear();
                    }
                    clientIdMap.put(clientId, clientId);
                }
                LayoutViewHandler.buildUIComponentTree(facesContext, childComponent, childLayoutElement);
                continue;
            }
            LayoutViewHandler.buildUIComponentTree(facesContext, parentComponent, childLayoutElement);
        }
    }

    private static Map<String, String> getClientIdMap(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        HashMap debugIdMap = (HashMap)requestMap.get("__debugIdMap");
        if (debugIdMap == null) {
            debugIdMap = new HashMap();
            requestMap.put("__debugIdMap", debugIdMap);
        }
        return debugIdMap;
    }

    public UIViewRoot restoreView(FacesContext facesContext, String viewId) {
        String layoutDefinitionKey;
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        if (requestMap.get(RESTORE_VIEW_ID) != null) {
            return this.createView(facesContext, viewId);
        }
        requestMap.put(RESTORE_VIEW_ID, viewId);
        if (!this.isMappedView(viewId)) {
            return this.oldViewHandler.restoreView(facesContext, viewId);
        }
        UIViewRoot viewRoot = StateManagerUtil.restoreView(facesContext, viewId, facesContext.getApplication().getViewHandler().calculateRenderKitId(facesContext));
        if (viewRoot != null && (layoutDefinitionKey = ViewRootUtil.getLayoutDefinitionKey(viewRoot)) != null) {
            facesContext.setViewRoot(viewRoot);
            LayoutDefinition layoutDefinition = ViewRootUtil.getLayoutDefinition(layoutDefinitionKey);
            layoutDefinition.decode(facesContext, (UIComponent)viewRoot);
        }
        return viewRoot;
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewToRender) throws IOException {
        LayoutDefinition layoutDefinition = ViewRootUtil.getLayoutDefinition(viewToRender);
        if (layoutDefinition == null) {
            this.oldViewHandler.renderView(facesContext, viewToRender);
        } else if (!facesContext.getPartialViewContext().isPartialRequest() || facesContext.getPartialViewContext().isRenderAll()) {
            ResponseWriter responseWriter = this.setupResponseWriter(facesContext);
            responseWriter.startDocument();
            layoutDefinition.encode(facesContext, (UIComponent)viewToRender);
            responseWriter.endDocument();
        } else {
            layoutDefinition.encode(facesContext, (UIComponent)viewToRender);
        }
    }

    private static void renderComponent(FacesContext facesContext, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(facesContext);
        if (component.getRendersChildren()) {
            component.encodeChildren(facesContext);
        } else {
            for (UIComponent childComponent : component.getChildren()) {
                LayoutViewHandler.renderComponent(facesContext, childComponent);
            }
        }
        component.encodeEnd(facesContext);
    }

    private ResponseWriter setupResponseWriter(FacesContext facesContext) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if (responseWriter != null) {
            return responseWriter;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        ServletResponse response = (ServletResponse)externalContext.getResponse();
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
        RenderKit renderKit = renderKitFactory.getRenderKit(facesContext, facesContext.getViewRoot().getRenderKitId());
        String contentTypeList = null;
        String userContentType = "text/html";
        if (userContentType != null && !userContentType.isEmpty()) {
            response.setContentType(userContentType);
        } else {
            contentTypeList = (String)externalContext.getRequestHeaderMap().get("Accept");
            if (contentTypeList == null) {
                contentTypeList = "text/html;q=1.0";
            }
        }
        String encodingType = LayoutViewHandler.getEncoding(facesContext);
        externalContext.getSessionMap().put("jakarta.faces.request.charset", encodingType);
        response.setCharacterEncoding(encodingType);
        responseWriter = renderKit.createResponseWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), encodingType), contentTypeList, encodingType);
        facesContext.setResponseWriter(responseWriter);
        response.setContentType(responseWriter.getContentType());
        return responseWriter;
    }

    public void writeState(FacesContext facesContext) throws IOException {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot == null || facesContext.getPartialViewContext().isPartialRequest() && !facesContext.getPartialViewContext().isRenderAll() || ViewRootUtil.getLayoutDefinition(viewRoot) == null) {
            this.oldViewHandler.writeState(facesContext);
        } else {
            StateManager stateManager = facesContext.getApplication().getStateManager();
            Object savedView = StateManagerUtil.saveView(facesContext, facesContext.getViewRoot().getViewId());
            if (savedView != null) {
                stateManager.writeState(facesContext, savedView);
            }
        }
    }

    public String getResourceURL(FacesContext facesContext, String resourcePath) {
        return this.oldViewHandler.getResourceURL(facesContext, resourcePath);
    }

    public String getWebsocketURL(FacesContext facesContext, String channel) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        return this.oldViewHandler.getActionURL(facesContext, viewId);
    }

    public Locale calculateLocale(FacesContext facesContext) {
        return this.oldViewHandler.calculateLocale(facesContext);
    }

    public String calculateRenderKitId(FacesContext facesContext) {
        return this.oldViewHandler.calculateRenderKitId(facesContext);
    }

    static {
        TypeConverter.registerTypeConversion(null, UIComponent.class, UICOMPONENT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(null, UIComponent.class.getName(), UICOMPONENT_TYPE_CONVERSION);
    }
}

