/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.ParameterizedInterfaceModel;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;

class ParameterizedInterfaceModelImpl
implements ParameterizedInterfaceModel {
    private final ReentrantLock lock = new ReentrantLock();
    final TypeProxy<ExtensibleType> rawInterface;
    final List<ParameterizedInterfaceModel> parameterizedTypes = new ArrayList<ParameterizedInterfaceModel>();

    ParameterizedInterfaceModelImpl(TypeProxy<ExtensibleType> rawInterface) {
        this.rawInterface = rawInterface;
    }

    void addParameterizedType(ParameterizedInterfaceModel type) {
        this.lock.lock();
        try {
            this.parameterizedTypes.add(type);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rawInterface.getName());
        if (!this.parameterizedTypes.isEmpty()) {
            sb.append("<");
            Iterator<ParameterizedInterfaceModel> parameterizedTypeItr = this.parameterizedTypes.iterator();
            while (parameterizedTypeItr.hasNext()) {
                sb.append(parameterizedTypeItr.next().getName());
                if (!parameterizedTypeItr.hasNext()) continue;
                sb.append(",");
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public TypeProxy<? extends ExtensibleType> getRawInterfaceProxy() {
        return this.rawInterface;
    }

    @Override
    public ExtensibleType getRawInterface() {
        return this.rawInterface.get();
    }

    @Override
    public String getRawInterfaceName() {
        return this.rawInterface.getName();
    }

    @Override
    public Collection<ParameterizedInterfaceModel> getParametizedTypes() {
        return Collections.unmodifiableCollection(this.parameterizedTypes);
    }

    public String toString() {
        return this.rawInterface.getName() + this.parameterizedTypes.stream().map(Object::toString).collect(Collectors.joining(", ", "<", ">"));
    }
}

