/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Collection;

public class ObjectInputStreamForClassloader
extends ObjectInputStream {
    private final Collection<ClassLoader> classLoaders;

    public ObjectInputStreamForClassloader(InputStream in, Collection<ClassLoader> classLoaders) throws IOException {
        super(in);
        this.classLoaders = classLoaders;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        for (ClassLoader cl : this.classLoaders) {
            try {
                Class<?> result = Class.forName(classDesc.getName(), false, cl);
                return result;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.resolveClass(classDesc);
    }
}

