/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class CommandResponse
implements Callable {
    private static final AtomicLong tokenCounter = new AtomicLong(0L);
    private long tokenId;
    private String respondingInstanceName;
    protected Object result;
    protected int expectedUpdateCount;
    private FutureTask future;
    private ResponseMediator mediator;

    public CommandResponse(ResponseMediator mediator) {
        this.mediator = mediator;
        this.tokenId = tokenCounter.incrementAndGet();
        this.future = new FutureTask(this);
    }

    public void setExpectedUpdateCount(int value) {
        this.expectedUpdateCount = value;
    }

    public int getExpectedUpdateCount() {
        return this.expectedUpdateCount;
    }

    public int decrementAndGetExpectedUpdateCount() {
        return --this.expectedUpdateCount;
    }

    public long getTokenId() {
        return this.tokenId;
    }

    public FutureTask getFuture() {
        return this.future;
    }

    public void setResult(Object v) {
        this.result = v;
        this.mediator.removeCommandResponse(this.tokenId);
        this.future.run();
    }

    public Object getTransientResult() {
        return this.result;
    }

    public void setTransientResult(Object temp) {
        this.result = temp;
    }

    public void setException(Exception ex) {
        this.setResult(ex);
    }

    public String getRespondingInstanceName() {
        return this.respondingInstanceName;
    }

    public void setRespondingInstanceName(String respondingInstanceName) {
        this.respondingInstanceName = respondingInstanceName;
    }

    public Object call() {
        return this.result;
    }
}

