/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.PageSeparator;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.el.ValueExpression;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.FacesContext;

public final class PageAlert
extends UIComponentBase
implements NamingContainer {
    public static final String PAGEALERT_INPUT_FACET = "pageAlertInput";
    public static final String PAGEALERT_TITLE_FACET = "pageAlertTitle";
    public static final String PAGEALERT_BUTTONS_FACET = "pageAlertButtons";
    public static final String PAGEALERT_SEPARATOR_FACET = "pageAlertSeparator";
    public static final String PAGEALERT_IMAGE_FACET = "pageAlertImage";
    private String alt = null;
    private String detail = null;
    private boolean escape = false;
    private boolean escapeSet = false;
    private String style = null;
    private String styleClass = null;
    private String summary = null;
    private int tabIndex = Integer.MIN_VALUE;
    private boolean tabIndexSet = false;
    private String title = null;
    private String type = null;
    private boolean visible = false;
    private boolean visibleSet = false;

    public PageAlert() {
        this.setRendererType("com.sun.webui.jsf.PageAlert");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.PageAlert";
    }

    public UIComponent getPageAlertInput() {
        return this.getFacet(PAGEALERT_INPUT_FACET);
    }

    public UIComponent getPageAlertTitle() {
        UIComponent titleFacet = this.getFacet(PAGEALERT_TITLE_FACET);
        if (titleFacet != null) {
            return titleFacet;
        }
        StaticText alertTitle = new StaticText();
        alertTitle.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, PAGEALERT_TITLE_FACET));
        alertTitle.setParent((UIComponent)this);
        alertTitle.setText(this.getSafeTitle());
        return alertTitle;
    }

    public UIComponent getPageAlertButtons() {
        UIComponent buttonFacet = this.getFacet(PAGEALERT_BUTTONS_FACET);
        return buttonFacet;
    }

    public UIComponent getPageAlertSeparator() {
        UIComponent separatorFacet = this.getFacet(PAGEALERT_SEPARATOR_FACET);
        if (separatorFacet != null) {
            return separatorFacet;
        }
        PageSeparator separator = new PageSeparator();
        separator.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, PAGEALERT_SEPARATOR_FACET));
        separator.setParent((UIComponent)this);
        return separator;
    }

    public UIComponent getPageAlertImage() {
        UIComponent imageFacet = this.getFacet(PAGEALERT_IMAGE_FACET);
        if (imageFacet != null) {
            return imageFacet;
        }
        Icon icon = ThemeUtilities.getIcon(this.getTheme(), this.getIconIdentifier());
        String imageAlt = this.getAlt();
        if (imageAlt != null) {
            icon.setAlt(imageAlt);
        }
        icon.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, PAGEALERT_IMAGE_FACET));
        icon.setParent((UIComponent)this);
        return icon;
    }

    public String getSafeTitle() {
        String alertTitle = this.getTitle();
        if (alertTitle == null && (alertTitle = this.getAlt()) == null) {
            alertTitle = "";
        }
        return alertTitle;
    }

    private String getIconIdentifier() {
        String alertType = this.getType();
        if (alertType != null) {
            if ((alertType = alertType.toLowerCase()).startsWith("warn")) {
                return "ALERT_WARNING_LARGE";
            }
            if (alertType.startsWith("ques")) {
                return "ALERT_HELP_LARGE";
            }
            if (alertType.startsWith("info")) {
                return "ALERT_INFO_LARGE";
            }
        }
        return "ALERT_ERROR_LARGE";
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public String getAlt() {
        if (this.alt != null) {
            return this.alt;
        }
        ValueExpression vb = this.getValueExpression("alt");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAlt(String newAlt) {
        this.alt = newAlt;
    }

    public String getDetail() {
        if (this.detail != null) {
            return this.detail;
        }
        ValueExpression vb = this.getValueExpression("detail");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setDetail(String newDetail) {
        this.detail = newDetail;
    }

    public boolean isEscape() {
        if (this.escapeSet) {
            return this.escape;
        }
        ValueExpression vb = this.getValueExpression("escape");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setEscape(boolean newEscape) {
        this.escape = newEscape;
        this.escapeSet = true;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public String getSummary() {
        if (this.summary != null) {
            return this.summary;
        }
        ValueExpression vb = this.getValueExpression("summary");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSummary(String newSummary) {
        this.summary = newSummary;
    }

    public int getTabIndex() {
        if (this.tabIndexSet) {
            return this.tabIndex;
        }
        ValueExpression vb = this.getValueExpression("tabIndex");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setTabIndex(int newTabIndex) {
        this.tabIndex = newTabIndex;
        this.tabIndexSet = true;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        ValueExpression vb = this.getValueExpression("title");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        ValueExpression vb = this.getValueExpression("type");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return "error";
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.alt = (String)values[1];
        this.detail = (String)values[2];
        this.escape = (Boolean)values[3];
        this.escapeSet = (Boolean)values[4];
        this.style = (String)values[5];
        this.styleClass = (String)values[6];
        this.summary = (String)values[7];
        this.tabIndex = (Integer)values[8];
        this.tabIndexSet = (Boolean)values[9];
        this.title = (String)values[10];
        this.type = (String)values[11];
        this.visible = (Boolean)values[12];
        this.visibleSet = (Boolean)values[13];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.alt, this.detail, this.escape ? Boolean.TRUE : Boolean.FALSE, this.escapeSet ? Boolean.TRUE : Boolean.FALSE, this.style, this.styleClass, this.summary, this.tabIndex, this.tabIndexSet ? Boolean.TRUE : Boolean.FALSE, this.title, this.type, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }
}

