/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper.type;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;

public class ReadLockAcquisitionMetadata
implements Serializable {
    private static final AtomicLong READ_LOCK_GLOBAL_ACQUISITION_NUMBER = new AtomicLong(0L);
    private final long readLockGlobalAcquisitionNumber = READ_LOCK_GLOBAL_ACQUISITION_NUMBER.incrementAndGet();
    private final Date dateOfReadLockAcquisition = new Date();
    private final ConcurrencyManager cacheKeyWhoseNumberOfReadersThreadIsIncrementing;
    private final int numberOfReadersOnCacheKeyBeforeIncrementingByOne;
    private final String currentThreadStackTraceInformation;
    private final long currentThreadStackTraceInformationCpuTimeCostMs;

    public ReadLockAcquisitionMetadata(ConcurrencyManager cacheKeyWhoseNumberOfReadersThreadIsIncrementing, int numberOfReadersOnCacheKeyBeforeIncrementingByOne, String currentThreadStackTraceInformation, long currentThreadStackTraceInformationCpuTimeCostMs) {
        this.cacheKeyWhoseNumberOfReadersThreadIsIncrementing = cacheKeyWhoseNumberOfReadersThreadIsIncrementing;
        this.numberOfReadersOnCacheKeyBeforeIncrementingByOne = numberOfReadersOnCacheKeyBeforeIncrementingByOne;
        this.currentThreadStackTraceInformation = currentThreadStackTraceInformation;
        this.currentThreadStackTraceInformationCpuTimeCostMs = currentThreadStackTraceInformationCpuTimeCostMs;
    }

    public long getReadLockGlobalAcquisitionNumber() {
        return this.readLockGlobalAcquisitionNumber;
    }

    public Date getDateOfReadLockAcquisition() {
        return this.dateOfReadLockAcquisition;
    }

    public ConcurrencyManager getCacheKeyWhoseNumberOfReadersThreadIsIncrementing() {
        return this.cacheKeyWhoseNumberOfReadersThreadIsIncrementing;
    }

    public int getNumberOfReadersOnCacheKeyBeforeIncrementingByOne() {
        return this.numberOfReadersOnCacheKeyBeforeIncrementingByOne;
    }

    public String getCurrentThreadStackTraceInformation() {
        return this.currentThreadStackTraceInformation;
    }

    public long getCurrentThreadStackTraceInformationCpuTimeCostMs() {
        return this.currentThreadStackTraceInformationCpuTimeCostMs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.readLockGlobalAcquisitionNumber ^ this.readLockGlobalAcquisitionNumber >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReadLockAcquisitionMetadata other = (ReadLockAcquisitionMetadata)obj;
        return this.readLockGlobalAcquisitionNumber == other.readLockGlobalAcquisitionNumber;
    }

    public String toString() {
        return "ReadLockAcquisitionMetadataDto [\nreadLockGlobalAcquisitionNumber=" + this.readLockGlobalAcquisitionNumber + "\n, dateOfReadLockAcquisition=" + this.dateOfReadLockAcquisition + "\n, cacheKeyWhoseNumberOfReadersThreadIsIncrementing=" + this.cacheKeyWhoseNumberOfReadersThreadIsIncrementing + "\n, numberOfReadersOnCacheKeyBeforeIncrementingByOne=" + this.numberOfReadersOnCacheKeyBeforeIncrementingByOne + "\n, currentThreadStackTraceInformation=" + this.currentThreadStackTraceInformation + "\n, currentThreadStackTraceInformationCpuTimeCostMs=" + this.currentThreadStackTraceInformationCpuTimeCostMs + "]\n";
    }
}

