/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    public static final String NEWLINE;
    public static final String EOL;

    private StringUtils() {
    }

    public static int safeLength(String s) {
        if (s == null) {
            return 0;
        }
        return s.length();
    }

    public static boolean ok(String s) {
        return s != null && !s.isEmpty();
    }

    public static String formatSQLException(SQLException ex) {
        assert (ex != null);
        StringBuilder sb = new StringBuilder("SQLException:\n");
        do {
            sb.append("SQLState: ").append(ex.getSQLState()).append('\n');
            sb.append("Message:  ").append(ex.getMessage()).append('\n');
            sb.append("Vendor:   ").append(ex.getErrorCode()).append('\n');
            sb.append('\n');
        } while ((ex = ex.getNextException()) != null);
        return sb.toString();
    }

    public static int maxWidth(Vector v) {
        int max = 0;
        if (v == null || v.size() <= 0 || !(v.elementAt(0) instanceof String)) {
            return 0;
        }
        for (int i = v.size() - 1; i >= 0; --i) {
            int len = ((String)v.elementAt(i)).length();
            if (len <= max) continue;
            max = len;
        }
        return max;
    }

    public static boolean isHex(String s) {
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            if (StringUtils.isHex(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHex(char c) {
        String hex = "0123456789abcdefABCDEF";
        int hexlen = hex.length();
        for (int i = 0; i < hexlen; ++i) {
            if (hex.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static String getPenultimateDirName(String s) {
        if (s == null || s.length() <= 0) {
            return s;
        }
        if (s.indexOf(47) < 0 && s.indexOf(92) < 0) {
            return "";
        }
        int index = (s = s.replace('\\', '/')).lastIndexOf(47);
        if (index < 0) {
            return "";
        }
        if ((index = (s = s.substring(0, index)).lastIndexOf(47)) >= 0) {
            s = s.substring(index + 1);
        }
        return s;
    }

    public static String toShortClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index >= 0 && index < className.length() - 1) {
            return className.substring(index + 1);
        }
        return className;
    }

    public static String padRight(String s, int len) {
        if (s == null || s.length() >= len) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        for (int i = len - s.length(); i > 0; --i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String padLeft(String s, int len) {
        if (s == null || s.length() >= len) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = len - s.length(); i > 0; --i) {
            sb.append(' ');
        }
        return sb.append(s).toString();
    }

    public static String[] toLines(String s) {
        if (s == null) {
            return new String[0];
        }
        Vector<String> v = new Vector<String>();
        int start = 0;
        int end = 0;
        end = s.indexOf(10, start);
        while (end >= 0 && start < s.length()) {
            v.addElement(s.substring(start, end));
            start = end + 1;
            end = s.indexOf(10, start);
        }
        if (start < s.length()) {
            v.addElement(s.substring(start));
        }
        Object[] ss = new String[v.size()];
        v.copyInto(ss);
        return ss;
    }

    public static void prepend(String[] ss, String what) {
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = what + ss[i];
        }
    }

    public static String upperCaseFirstLetter(String s) {
        if (s == null || s.length() <= 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase(Locale.getDefault()) + s.substring(1);
    }

    public static String replace(String s, String token, String replace) {
        if (s == null || s.length() <= 0 || token == null || token.length() <= 0) {
            return s;
        }
        int index = s.indexOf(token);
        if (index < 0) {
            return s;
        }
        int tokenLength = token.length();
        Object ret = s.substring(0, index);
        ret = (String)ret + replace;
        ret = (String)ret + s.substring(index + tokenLength);
        return ret;
    }

    public static String toString(Properties props) {
        String key;
        Map.Entry<Object, Object> me;
        if (props == null || props.size() <= 0) {
            return "No entries";
        }
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        StringBuffer sb = new StringBuffer();
        int keyWidth = 0;
        for (Map.Entry<Object, Object> entry : entries) {
            me = entry;
            key = (String)me.getKey();
            int len = key.length();
            if (len <= keyWidth) continue;
            keyWidth = len;
        }
        ++keyWidth;
        Iterator<Map.Entry<Object, Object>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry;
            me = entry = iterator.next();
            key = (String)me.getKey();
            String val = (String)me.getValue();
            sb.append(StringUtils.padRight(key, keyWidth));
            sb.append("= ");
            sb.append(val);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        int len = args.length;
        if (len == 1 && args[0].equalsIgnoreCase("toLine")) {
            StringUtils.testToLine();
        } else if (len > 1 && args[0].equalsIgnoreCase("isHex")) {
            StringUtils.testHex(args);
        } else {
            StringUtils.usage();
        }
    }

    private static void usage() {
        System.out.println("StringUtils -- main() for testing usage:\n");
        System.out.println("java netscape.blizzard.util.StringUtils toLine");
        System.out.println("java netscape.blizzard.util.StringUtils isHex number1 number2 ...");
    }

    private static void testHex(String[] args) {
        System.out.println("StringUtils -- Testing Hex");
        for (int i = 1; i < args.length; ++i) {
            System.out.println(StringUtils.padRight(args[i], 16) + "  " + (StringUtils.isHex(args[i]) ? "yesHex" : "notHex"));
        }
    }

    private static void testToLine() {
        System.out.println("StringUtils -- Testing toLine()");
        String[] ss = new String[]{null, "", "abc\ndef\n", "abc\ndef", "abc", "abc\n", "abc\n\n", "q", "\n\nk\n\nz\n\n", "sd.adj;ld"};
        for (int k = 0; k < ss.length; ++k) {
            String[] s2 = StringUtils.toLines(ss[k]);
            System.out.println("String #" + k + ", Number of Lines:  " + s2.length);
            for (String element : s2) {
                System.out.println(element);
            }
        }
    }

    public static void testUpperCase() {
        String[] test;
        for (String element : test = new String[]{"xyz", "HITHERE", "123aa", "aSSS", "yothere"}) {
            System.out.println(element + " >>> " + StringUtils.upperCaseFirstLetter(element));
        }
    }

    public static String makeFilePath(String[] strings, boolean addTrailing) {
        StringBuffer path = new StringBuffer();
        String separator = System.getProperty("file.separator");
        if (strings != null) {
            for (int i = 0; i < strings.length; ++i) {
                String element = strings[i];
                if (element == null || element.length() == 0) {
                    throw new IllegalArgumentException();
                }
                path.append(element);
                if (i >= strings.length - 1) continue;
                path.append(separator);
            }
            if (addTrailing) {
                path.append(separator);
            }
        }
        return path.toString();
    }

    public static List<String> parseStringList(String line) {
        return StringUtils.parseStringList(line, null);
    }

    public static List<String> parseStringList(String line, String sep) {
        if (line == null) {
            return null;
        }
        StringTokenizer st = sep == null ? new StringTokenizer(line) : new StringTokenizer(line, sep);
        Vector<String> tokens = new Vector<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static String removeChar(String strOrig, char c) {
        StringBuilder strNew = new StringBuilder();
        for (int i = 0; i < strOrig.length(); ++i) {
            if (strOrig.charAt(i) == c) continue;
            strNew.append(strOrig.charAt(i));
        }
        return strNew.toString();
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static final boolean isToken(String s) {
        return s != null && s.startsWith("${") && s.endsWith("}") && s.length() > 3;
    }

    public static final String stripToken(String s) {
        if (StringUtils.isToken(s)) {
            return s.substring(2, s.length() - 1);
        }
        return s;
    }

    public static String cat(String separator, String ... list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : list) {
            if (!StringUtils.ok(s)) continue;
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String removeEnclosingQuotes(String s) {
        if (s == null) {
            return null;
        }
        if (StringUtils.isDoubleQuoted(s) || StringUtils.isSingleQuoted(s)) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String quotePathIfNecessary(String path) {
        return StringUtils.quotePathIfNecessary(path, '\"');
    }

    public static String quotePathIfNecessary(String path, char quoteChar) {
        if (!StringUtils.ok(path) || !StringUtils.needsQuoting(path) || StringUtils.isDoubleQuoted(path) || StringUtils.isSingleQuoted(path)) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(quoteChar);
        sb.append(path);
        sb.append(quoteChar);
        return sb.toString();
    }

    private static boolean needsQuoting(String path) {
        return StringUtils.ok(path) && (path.indexOf(32) >= 0 || path.indexOf(9) >= 0);
    }

    private static boolean isDoubleQuoted(String s) {
        return s.startsWith("\"") && s.endsWith("\"") && s.length() > 1;
    }

    private static boolean isSingleQuoted(String s) {
        return s.startsWith("'") && s.endsWith("'") && s.length() > 1;
    }

    public static String escapeForHtml(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(str.length() + 16);
        block7: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                case '&': {
                    result.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block7;
                }
                case '\t': {
                    result.append("&#009;");
                    continue block7;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    public static String nvl(String str) {
        return str == null ? "" : str;
    }

    static {
        EOL = NEWLINE = System.getProperty("line.separator");
    }
}

