/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.contexts;

import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.util.Collection;
import org.jboss.weld.context.WeldAlterableContext;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.ForwardingContext;

public class PassivatingContextWrapper {
    private PassivatingContextWrapper() {
    }

    public static Context wrap(Context context, ContextualStore store) {
        if (context instanceof WeldAlterableContext) {
            return new WeldAlterableContextWrapper((WeldAlterableContext)context, store);
        }
        if (context instanceof AlterableContext) {
            return new AlterableContextWrapper((AlterableContext)context, store);
        }
        return new ContextWrapper(context, store);
    }

    public static Context unwrap(Context context) {
        if (context instanceof AbstractPassivatingContextWrapper) {
            AbstractPassivatingContextWrapper wrapper = (AbstractPassivatingContextWrapper)context;
            return wrapper.delegate();
        }
        return context;
    }

    private static class WeldAlterableContextWrapper
    extends AbstractPassivatingContextWrapper<WeldAlterableContext>
    implements WeldAlterableContext {
        public WeldAlterableContextWrapper(WeldAlterableContext context, ContextualStore store) {
            super(context, store);
        }

        public void destroy(Contextual<?> contextual) {
            contextual = this.store.getSerializableContextual(contextual);
            ((WeldAlterableContext)this.delegate()).destroy(contextual);
        }

        @Override
        public Collection<ContextualInstance<?>> getAllContextualInstances() {
            return ((WeldAlterableContext)this.delegate()).getAllContextualInstances();
        }

        @Override
        public void clearAndSet(Collection<ContextualInstance<?>> setOfInstances) {
            ((WeldAlterableContext)this.delegate()).clearAndSet(setOfInstances);
        }
    }

    private static class AlterableContextWrapper
    extends AbstractPassivatingContextWrapper<AlterableContext>
    implements AlterableContext {
        public AlterableContextWrapper(AlterableContext context, ContextualStore store) {
            super(context, store);
        }

        public void destroy(Contextual<?> contextual) {
            contextual = this.store.getSerializableContextual(contextual);
            ((AlterableContext)this.delegate()).destroy(contextual);
        }
    }

    private static class ContextWrapper
    extends AbstractPassivatingContextWrapper<Context> {
        public ContextWrapper(Context context, ContextualStore store) {
            super(context, store);
        }
    }

    private static abstract class AbstractPassivatingContextWrapper<C extends Context>
    extends ForwardingContext {
        private final C context;
        protected final ContextualStore store;

        public AbstractPassivatingContextWrapper(C context, ContextualStore store) {
            this.context = context;
            this.store = store;
        }

        @Override
        public <T> T get(Contextual<T> contextual) {
            contextual = this.store.getSerializableContextual(contextual);
            return (T)this.context.get(contextual);
        }

        @Override
        public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
            contextual = this.store.getSerializableContextual(contextual);
            return (T)this.context.get(contextual, creationalContext);
        }

        protected C delegate() {
            return this.context;
        }
    }
}

