/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.exceptions.BadRealmException;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.cli.CLIUtil;
import com.sun.enterprise.security.cli.CreateFileUser;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.io.File;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="delete-file-user")
@PerLookup
@I18n(value="delete.file.user")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=AuthRealm.class, opType=RestEndpoint.OpType.DELETE, path="delete-user", description="Delete", params={@RestParam(name="authrealmname", value="$parent")})})
public class DeleteFileUser
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteFileUser.class);
    @Param(name="authrealmname", optional=true)
    private String authRealmName;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Param(name="username", primary=true)
    private String userName;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    @Inject
    private RealmsManager realmsManager;
    @AccessRequired.To(value={"update"})
    private AuthRealm fileAuthRealm;
    private SecurityService securityService;

    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.chooseConfig(this.domain, this.target, context.getActionReport());
        if (this.config == null) {
            return false;
        }
        this.securityService = this.config.getSecurityService();
        this.fileAuthRealm = CLIUtil.findRealm(this.securityService, this.authRealmName);
        if (this.fileAuthRealm == null) {
            ActionReport report = context.getActionReport();
            report.setMessage(localStrings.getLocalString("delete.file.user.filerealmnotfound", "File realm {0} does not exist", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        this.authRealmName = this.fileAuthRealm.getName();
        return true;
    }

    public void execute(AdminCommandContext context) {
        final ActionReport report = context.getActionReport();
        String fileRealmClassName = this.fileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            report.setMessage(localStrings.getLocalString("delete.file.user.realmnotsupported", "Configured file realm {0} is not supported.", new Object[]{fileRealmClassName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String keyFile = null;
        for (Property fileProp : this.fileAuthRealm.getProperty()) {
            if (!fileProp.getName().equals("file")) continue;
            keyFile = fileProp.getValue();
        }
        String kFile = keyFile;
        if (keyFile == null) {
            report.setMessage(localStrings.getLocalString("delete.file.user.keyfilenotfound", "There is no physical file associated with this file realm {0} ", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        boolean exists = new File(kFile).exists();
        if (!exists) {
            report.setMessage(localStrings.getLocalString("file.realm.keyfilenonexistent", "The specified physical file {0} associated with the file realm {1} does not exist.", new Object[]{kFile, this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityService>(){

                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    try {
                        DeleteFileUser.this.realmsManager.createRealms(DeleteFileUser.this.config);
                        FileRealm fr = (FileRealm)DeleteFileUser.this.realmsManager.getFromLoadedRealms(DeleteFileUser.this.config.getName(), DeleteFileUser.this.authRealmName);
                        fr.removeUser(DeleteFileUser.this.userName);
                        fr.persist();
                        CreateFileUser.refreshRealm(DeleteFileUser.this.config.getName(), DeleteFileUser.this.authRealmName);
                        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    }
                    catch (NoSuchUserException e) {
                        report.setMessage(localStrings.getLocalString("delete.file.user.usernotfound", "There is no such existing user {0} in the file realm {1}.", new Object[]{DeleteFileUser.this.userName, DeleteFileUser.this.authRealmName}) + "  " + e.getLocalizedMessage());
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setFailureCause((Throwable)e);
                    }
                    catch (BadRealmException e) {
                        report.setMessage(localStrings.getLocalString("delete.file.user.realmcorrupted", "Configured file realm {0} is corrupted.", new Object[]{DeleteFileUser.this.authRealmName}) + "  " + e.getLocalizedMessage());
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setFailureCause((Throwable)e);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        report.setMessage(localStrings.getLocalString("delete.file.user.userdeletefailed", "Removing User {0} from file realm {1} failed", new Object[]{DeleteFileUser.this.userName, DeleteFileUser.this.authRealmName}) + "  " + e.getLocalizedMessage());
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setFailureCause((Throwable)e);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)this.securityService);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("delete.file.user.userdeletefailed", "Removing User {0} from file realm {1} failed", new Object[]{this.userName, this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

