/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.glassfish.deployment.common.Descriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class LocalizedNode
extends DeploymentDescriptorNode<Descriptor> {
    private String lang;
    private String localizedValue;

    protected String getLang() {
        return this.lang;
    }

    protected String getLocalizedValue() {
        return this.localizedValue;
    }

    @Override
    public void startElement(XMLElement element, Attributes attributes) {
        if (attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getLocalName(i).equals("lang")) continue;
                this.lang = attributes.getValue(i);
            }
        }
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if (element.equals(this.getXMLRootTag())) {
            this.localizedValue = value;
        } else {
            super.setElementValue(element, value);
        }
    }

    public void writeLocalizedMap(Node parentNode, String tagName, Map<String, String> localizedMap) {
        if (localizedMap == null) {
            return;
        }
        Set<Map.Entry<String, String>> entrySet = localizedMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String entryLang = entry.getKey();
            Element aLocalizedNode = (Element)LocalizedNode.appendTextChild(parentNode, tagName, entry.getValue());
            if (aLocalizedNode == null || !Locale.getDefault().getLanguage().equals(entryLang)) continue;
            String qualifiedName = "xml:lang";
            aLocalizedNode.setAttributeNS("http://www.w3.org/XML/1998/namespace", qualifiedName, entryLang);
        }
    }
}

