/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.derby.impl.store.raw.data.ByteHolder;

public class MemByteHolder
implements ByteHolder {
    int bufSize;
    boolean writing = true;
    Vector<byte[]> bufV;
    int curBufVEleAt;
    byte[] curBuf;
    int curBufPos;
    int curBufDataBytes;
    int lastBufVEleAt = 0;
    int lastBufDataBytes = 0;

    public MemByteHolder(int n) {
        this.bufSize = n;
        this.curBuf = new byte[n];
        this.curBufPos = 0;
        this.bufV = new Vector(128);
        this.bufV.addElement(this.curBuf);
        this.curBufVEleAt = 0;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.curBufPos >= this.curBuf.length) {
            this.getNextBuffer_w();
        }
        this.curBuf[this.curBufPos++] = (byte)n;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3;
            int n4;
            if (this.curBufPos >= this.curBuf.length) {
                this.getNextBuffer_w();
            }
            if ((n4 = n2) > (n3 = this.curBuf.length - this.curBufPos)) {
                n4 = n3;
            }
            System.arraycopy(byArray, n, this.curBuf, this.curBufPos, n4);
            n += n4;
            this.curBufPos += n4;
            n2 -= n4;
        }
    }

    @Override
    public long write(InputStream inputStream, long l) throws IOException {
        long l2 = l;
        int n = 0;
        do {
            int n2;
            int n3;
            if (this.curBufPos >= this.curBuf.length) {
                this.getNextBuffer_w();
            }
            if ((n = inputStream.read(this.curBuf, this.curBufPos, n3 = l2 >= (long)(n2 = this.curBuf.length - this.curBufPos) ? n2 : (int)l2)) <= 0) continue;
            l2 -= (long)n;
            this.curBufPos += n;
        } while (l2 > 0L && n > 0);
        return l - l2;
    }

    @Override
    public void clear() throws IOException {
        this.writing = true;
        this.curBuf = this.bufV.elementAt(0);
        this.curBufVEleAt = 0;
        this.curBufPos = 0;
        this.lastBufVEleAt = 0;
        this.lastBufDataBytes = 0;
    }

    @Override
    public void startReading() throws IOException {
        if (this.writing) {
            this.writing = false;
            this.lastBufDataBytes = this.curBufPos;
            this.lastBufVEleAt = this.curBufVEleAt;
        }
        this.curBuf = this.bufV.elementAt(0);
        this.curBufVEleAt = 0;
        this.curBufPos = 0;
        this.curBufDataBytes = this.curBufVEleAt == this.lastBufVEleAt ? this.lastBufDataBytes : this.bufSize;
    }

    @Override
    public int read() throws IOException {
        if (this.curBufPos >= this.curBufDataBytes) {
            this.getNextBuffer_r();
        }
        if (this.curBufPos >= this.curBufDataBytes) {
            return -1;
        }
        return 0xFF & this.curBuf[this.curBufPos++];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.read(byArray, n, null, n2);
    }

    @Override
    public int read(OutputStream outputStream, int n) throws IOException {
        return this.read(null, 0, outputStream, n);
    }

    public int read(byte[] byArray, int n, OutputStream outputStream, int n2) throws IOException {
        int n3 = 0;
        boolean bl = false;
        if (this.curBufPos >= this.curBufDataBytes) {
            bl = this.getNextBuffer_r();
        }
        if (bl) {
            return -1;
        }
        while (n2 > 0 && !bl) {
            int n4 = this.curBufDataBytes - this.curBufPos;
            int n5 = n2 >= n4 ? n4 : n2;
            if (outputStream == null) {
                System.arraycopy(this.curBuf, this.curBufPos, byArray, n, n5);
            } else {
                outputStream.write(this.curBuf, this.curBufPos, n5);
            }
            n += n5;
            this.curBufPos += n5;
            n2 -= n5;
            n3 += n5;
            if (this.curBufPos < this.curBufDataBytes) continue;
            bl = this.getNextBuffer_r();
        }
        return n3;
    }

    @Override
    public int shiftToFront() throws IOException {
        int n = this.available();
        n = n > 0 ? n : -1 * n;
        byte[] byArray = new byte[n + 1];
        int n2 = this.read(byArray, 0, n);
        this.clear();
        this.writing = true;
        this.write(byArray, 0, n2);
        this.curBufDataBytes = 0;
        return n2;
    }

    @Override
    public int available() {
        int n = this.curBufDataBytes - this.curBufPos;
        int n2 = 0;
        int n3 = 0;
        if (this.curBufVEleAt != this.lastBufVEleAt) {
            n3 = this.lastBufVEleAt - this.curBufVEleAt - 1;
            n2 = this.lastBufDataBytes;
        }
        int n4 = n + n2 + n3 * this.bufSize;
        return n4;
    }

    @Override
    public int numBytesSaved() {
        int n = this.writing ? this.curBufVEleAt * this.bufSize + this.curBufPos : this.lastBufVEleAt * this.bufSize + this.lastBufDataBytes;
        return n;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        boolean bl = false;
        if (this.curBufPos >= this.curBufDataBytes) {
            bl = this.getNextBuffer_r();
        }
        while (l > 0L && !bl) {
            int n = this.curBufDataBytes - this.curBufPos;
            int n2 = l >= (long)n ? n : (int)l;
            this.curBufPos += n2;
            l2 += (long)n2;
            if ((l -= (long)n2) <= 0L) continue;
            bl = this.getNextBuffer_r();
        }
        return l2;
    }

    @Override
    public boolean writingMode() {
        return this.writing;
    }

    @Override
    public ByteHolder cloneEmpty() {
        return new MemByteHolder(this.bufSize);
    }

    protected void getNextBuffer_w() throws IOException {
        ++this.curBufVEleAt;
        if (this.bufV.size() <= this.curBufVEleAt) {
            this.curBuf = new byte[this.bufSize];
            this.bufV.addElement(this.curBuf);
        } else {
            this.curBuf = this.bufV.elementAt(this.curBufVEleAt);
        }
        this.initBuffer_w();
    }

    protected void getNextBuffer_w_Sanity() {
    }

    protected void initBuffer_w() {
        this.curBufPos = 0;
    }

    protected boolean getNextBuffer_r() throws IOException {
        if (this.curBufVEleAt >= this.lastBufVEleAt) {
            return true;
        }
        this.curBuf = this.bufV.elementAt(++this.curBufVEleAt);
        this.curBufPos = 0;
        this.curBufDataBytes = this.curBufVEleAt == this.lastBufVEleAt ? this.lastBufDataBytes : this.bufSize;
        return false;
    }

    private String dumpBuf(int n) {
        StringBuffer stringBuffer = new StringBuffer(100);
        byte[] byArray = this.bufV.elementAt(n);
        stringBuffer.append("(");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i] + ".");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toString() {
        return " writing: " + this.writing + " curBufVEleAt: " + this.curBufVEleAt + " curBufPos: " + this.curBufPos + " curBufDataBytes: " + this.curBufDataBytes + " lastBufVEleAt: " + this.lastBufVEleAt + " lastBufDataBytes: " + this.lastBufDataBytes + " curBuf: " + this.dumpBuf(this.curBufVEleAt);
    }
}

