/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.expressly.parser;

import jakarta.el.ELClass;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.ImportHandler;
import jakarta.el.MethodInfo;
import jakarta.el.MethodReference;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.ValueReference;
import java.lang.reflect.Method;
import org.glassfish.expressly.lang.ELSupport;
import org.glassfish.expressly.lang.EvaluationContext;
import org.glassfish.expressly.parser.AstBracketSuffix;
import org.glassfish.expressly.parser.AstDotSuffix;
import org.glassfish.expressly.parser.AstIdentifier;
import org.glassfish.expressly.parser.AstMethodArguments;
import org.glassfish.expressly.parser.Node;
import org.glassfish.expressly.parser.SimpleNode;
import org.glassfish.expressly.util.MessageFactory;
import org.glassfish.expressly.util.ReflectionUtil;

public final class AstValue
extends SimpleNode {
    public AstValue(int id) {
        super(id);
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) throws ELException {
        Target target = this.getTarget(ctx);
        if (target.isMethodCall()) {
            return null;
        }
        Object property = target.getProperty();
        ctx.setPropertyResolved(false);
        Class type = ctx.getELResolver().getType((ELContext)ctx, target.getBase(), property);
        if (!ctx.isPropertyResolved()) {
            ELSupport.throwUnhandled(target.base, property);
        }
        return type;
    }

    @Override
    public ValueReference getValueReference(EvaluationContext ctx) throws ELException {
        Target target = this.getTarget(ctx);
        if (target.isMethodCall()) {
            return null;
        }
        return new ValueReference(target.getBase(), target.getProperty());
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        Object value = this.getBase(ctx);
        int propCount = this.jjtGetNumChildren();
        for (int i = 1; value != null && i < propCount; ++i) {
            value = this.getValue(value, this.children[i], ctx);
        }
        return value;
    }

    @Override
    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        Target target = this.getTarget(ctx);
        if (target.isMethodCall()) {
            return true;
        }
        Object property = target.getProperty();
        ctx.setPropertyResolved(false);
        boolean isReadOnly = ctx.getELResolver().isReadOnly((ELContext)ctx, target.getBase(), property);
        if (!ctx.isPropertyResolved()) {
            ELSupport.throwUnhandled(target.getBase(), property);
        }
        return isReadOnly;
    }

    @Override
    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        Target target = this.getTarget(ctx);
        if (target.isMethodCall()) {
            throw new PropertyNotWritableException(MessageFactory.get("error.syntax.set"));
        }
        Object property = target.getProperty();
        ELResolver elResolver = ctx.getELResolver();
        ctx.setPropertyResolved(false);
        Class targetType = elResolver.getType((ELContext)ctx, target.getBase(), property);
        if (ctx.isPropertyResolved()) {
            ctx.setPropertyResolved(false);
            Object targetValue = elResolver.convertToType((ELContext)ctx, value, targetType);
            if (ctx.isPropertyResolved()) {
                value = targetValue;
            } else if (value != null || targetType != null && targetType.isPrimitive()) {
                value = ELSupport.coerceToType(ctx.getELContext(), value, targetType);
            }
        }
        ctx.setPropertyResolved(false);
        elResolver.setValue((ELContext)ctx, target.getBase(), property, value);
        if (!ctx.isPropertyResolved()) {
            ELSupport.throwUnhandled(target.getBase(), property);
        }
    }

    @Override
    public MethodInfo getMethodInfo(EvaluationContext ctx, Class<?>[] paramTypes) throws ELException {
        Target target = this.getTarget(ctx);
        Method method = ReflectionUtil.findMethod(target.getBase().getClass(), target.getMethodName(), paramTypes, target.getParamValues());
        return new MethodInfo(method.getName(), method.getReturnType(), (Class[])method.getParameterTypes());
    }

    @Override
    public MethodReference getMethodReference(EvaluationContext ctx) {
        Target target = this.getTarget(ctx);
        Method method = ReflectionUtil.findMethod(target.getBase().getClass(), target.getMethodName(), target.getActualParamTypes(), target.getParamValues());
        return new MethodReference(target.getBase(), this.getMethodInfo(ctx, target.getActualParamTypes()), method.getAnnotations(), ReflectionUtil.buildParameters(ctx.getELContext(), target.getActualParamTypes(), method.isVarArgs(), target.getParamValues()));
    }

    @Override
    public Object invoke(EvaluationContext ctx, Class<?>[] paramTypes, Object[] paramValues) throws ELException {
        Target target = this.getTarget(ctx);
        if (target.isMethodCall()) {
            ctx.setPropertyResolved(false);
            return ctx.getELResolver().invoke((ELContext)ctx, target.getBase(), (Object)target.getMethodName(), (Class[])target.getFormalParamTypes(), target.getParamValues());
        }
        return ReflectionUtil.invokeMethod(ctx, ReflectionUtil.findMethod(target.getBase().getClass(), target.getProperty().toString(), paramTypes, paramValues), target.getBase(), paramValues);
    }

    @Override
    public boolean isParametersProvided() {
        return AstValue.getArguments(this.children[this.jjtGetNumChildren() - 1]) != null;
    }

    private static AstMethodArguments getArguments(Node node) {
        if (node instanceof AstDotSuffix && node.jjtGetNumChildren() > 0) {
            return (AstMethodArguments)node.jjtGetChild(0);
        }
        if (node instanceof AstBracketSuffix && node.jjtGetNumChildren() > 1) {
            return (AstMethodArguments)node.jjtGetChild(1);
        }
        return null;
    }

    private Object getValue(Object base, Node child, EvaluationContext ctx) throws ELException {
        Object value = null;
        ELResolver resolver = ctx.getELResolver();
        Object property = child.getValue(ctx);
        AstMethodArguments args = AstValue.getArguments(child);
        if (args != null) {
            if (!(property instanceof String)) {
                throw new ELException(MessageFactory.get("error.method.name", property));
            }
            Class[] paramTypes = args.getParamTypes();
            Object[] params = args.getParameters(ctx);
            ctx.setPropertyResolved(false);
            value = resolver.invoke((ELContext)ctx, base, property, paramTypes, params);
        } else if (property != null) {
            ctx.setPropertyResolved(false);
            value = resolver.getValue((ELContext)ctx, base, property);
            if (!ctx.isPropertyResolved()) {
                ELSupport.throwUnhandled(base, property);
            }
        }
        return value;
    }

    private Object getBase(EvaluationContext ctx) {
        try {
            return this.children[0].getValue(ctx);
        }
        catch (PropertyNotFoundException ex) {
            if (this.children[0] instanceof AstIdentifier) {
                Class resolvedClass;
                String name = ((AstIdentifier)this.children[0]).image;
                ImportHandler importHandler = ctx.getImportHandler();
                if (importHandler != null && (resolvedClass = importHandler.resolveClass(name)) != null) {
                    return new ELClass(resolvedClass);
                }
            }
            throw ex;
        }
    }

    private Target getTarget(EvaluationContext ctx) throws ELException {
        Object base = this.getBase(ctx);
        if (base == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.base", this.children[0].getImage()));
        }
        Object property = null;
        int propCount = this.jjtGetNumChildren() - 1;
        if (propCount > 1) {
            for (int i = 1; base != null && i < propCount; ++i) {
                base = this.getValue(base, this.children[i], ctx);
            }
            if (base == null) {
                throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", property));
            }
        }
        return new Target(base, this.children[propCount], ctx);
    }

    protected static class Target {
        private final Object base;
        private final Node suffixNode;
        private final EvaluationContext ctx;

        Target(Object base, Node suffixNode, EvaluationContext ctx) {
            this.base = base;
            this.suffixNode = suffixNode;
            this.ctx = ctx;
        }

        public Object getBase() {
            return this.base;
        }

        public String getMethodName() {
            return this.getProperty().toString();
        }

        public Object getProperty() {
            return this.suffixNode.getValue(this.ctx);
        }

        boolean isMethodCall() {
            return AstValue.getArguments(this.suffixNode) != null;
        }

        Object[] getParamValues() {
            AstMethodArguments arguments = AstValue.getArguments(this.suffixNode);
            if (arguments == null) {
                return null;
            }
            return arguments.getParameters(this.ctx);
        }

        Class<?>[] getFormalParamTypes() {
            AstMethodArguments arguments = AstValue.getArguments(this.suffixNode);
            if (arguments == null) {
                return null;
            }
            return arguments.getParamTypes();
        }

        Class<?>[] getActualParamTypes() {
            Object[] values = this.getParamValues();
            if (values == null) {
                return null;
            }
            return ReflectionUtil.getTypesFromValues(values);
        }
    }
}

