/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport.connection;

import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.concurrent.ConcurrentQueue;
import com.sun.corba.ee.spi.transport.connection.Connection;
import com.sun.corba.ee.spi.transport.connection.ConnectionCache;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
public abstract class ConnectionCacheBase<C extends Connection>
implements ConnectionCache<C> {
    private boolean flag;
    private final String cacheType;
    private final int highWaterMark;
    private final int numberToReclaim;
    protected ConcurrentQueue<C> reclaimableConnections = null;

    @Override
    public final String getCacheType() {
        return this.cacheType;
    }

    @Override
    public final int numberToReclaim() {
        return this.numberToReclaim;
    }

    @Override
    public final int highWaterMark() {
        return this.highWaterMark;
    }

    protected abstract String thisClassName();

    ConnectionCacheBase(String cacheType, int highWaterMark, int numberToReclaim) {
        if (cacheType == null) {
            throw new IllegalArgumentException("cacheType must not be null");
        }
        if (highWaterMark < 0) {
            throw new IllegalArgumentException("highWaterMark must be non-negative");
        }
        if (numberToReclaim < 1) {
            throw new IllegalArgumentException("numberToReclaim must be at least 1");
        }
        this.cacheType = cacheType;
        this.highWaterMark = highWaterMark;
        this.numberToReclaim = numberToReclaim;
    }

    public String toString() {
        return this.thisClassName() + "[" + this.getCacheType() + "]";
    }

    @InfoMethod
    private void display(String msg, Object value) {
    }

    @Transport
    protected boolean reclaim() {
        ConcurrentQueue.Handle<C> candidate;
        int ctr;
        for (ctr = 0; ctr < this.numberToReclaim() && (candidate = this.reclaimableConnections.poll()) != null; ++ctr) {
            try {
                this.display("closing connection", candidate);
                this.close((Connection)candidate.value());
                continue;
            }
            catch (RuntimeException exc) {
                this.display("exception on close", exc);
                throw exc;
            }
        }
        this.display("number of connections reclaimed", ctr);
        return ctr > 0;
    }
}

