/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding.convert.impl;

import java.lang.annotation.Annotation;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.krazo.binding.convert.ConverterResult;
import org.eclipse.krazo.binding.convert.impl.NumberConverter;

public class BigIntegerConverter
extends NumberConverter<BigInteger> {
    @Override
    public boolean supports(Class<BigInteger> rawType, Annotation[] annotations) {
        return BigInteger.class.equals(rawType);
    }

    @Override
    public ConverterResult<BigInteger> convert(String value, Class<BigInteger> rawType, Annotation[] annotations, Locale locale) {
        try {
            return ConverterResult.success(this.parseNumber(value, locale).map(val -> new BigInteger(val.toString())).orElse(null));
        }
        catch (NumberFormatException | ParseException e) {
            return ConverterResult.failed(null, e.getMessage());
        }
    }
}

