/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.cli.ServerLifeSignCheck;
import com.sun.enterprise.admin.servermgmt.cli.StartServerCommand;
import com.sun.enterprise.admin.servermgmt.cli.StartServerHelper;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.ObjectAnalyzer;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.glassfish.security.common.FileRealmHelper;
import org.jvnet.hk2.annotations.Service;

@Service(name="start-domain")
@PerLookup
public class StartDomainCommand
extends LocalDomainCommand
implements StartServerCommand {
    private static final LocalStringsImpl I18N = new LocalStringsImpl(StartDomainCommand.class);
    @Param(optional=true, shortName="v", defaultValue="false")
    private boolean verbose;
    @Param(optional=true, defaultValue="false")
    private boolean upgrade;
    @Param(optional=true, shortName="w", defaultValue="false")
    private boolean watchdog;
    @Param(optional=true, shortName="d", defaultValue="false")
    private boolean debug;
    @Param(optional=true, shortName="s", defaultValue="false")
    private boolean suspend;
    @Param(name="dry-run", shortName="n", optional=true, defaultValue="false")
    private boolean dryRun;
    @Param(optional=true)
    private Integer timeout;
    @Param(name="check-pid-file", optional=true, defaultValue="true")
    private boolean checkPidFile;
    @Param(name="check-process-alive", optional=true, defaultValue="true")
    private boolean checkProcessAlive;
    @Param(name="check-admin-port", optional=true, defaultValue="true")
    private boolean checkAdminEndpoint;
    @Param(name="server-output", shortName="o", optional=true)
    private Boolean printServerOutput;
    @Param(name="custom-endpoints", optional=true)
    private String customEndpoints;
    @Param(name="drop-interrupted-commands", optional=true, defaultValue="false")
    private boolean dropInterruptedCommands;
    @Param(name="domain_name", primary=true, optional=true)
    private String userArgDomainName;
    private GFLauncherInfo launchParameters;
    private GFLauncher launcher;
    private StartServerHelper startServerHelper;
    private final String newpwName = Environment.getPrefix() + "NEWPASSWORD";

    @Override
    public RuntimeType getType() {
        return RuntimeType.DAS;
    }

    @Override
    public Duration getTimeout() {
        return this.timeout == null ? CLIConstants.WAIT_FOR_DAS_TIME_MS : Duration.ofSeconds(this.timeout.intValue());
    }

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.setDomainName(this.userArgDomainName);
        super.validate();
    }

    protected int executeCommand() throws CommandException {
        try {
            this.launcher = this.createLauncher();
            List<HostAndPort> userEndpoints = StartServerHelper.parseCustomEndpoints(this.customEndpoints);
            ServerLifeSignCheck signOfLife = new ServerLifeSignCheck("domain " + this.getDomainName(), this.printServerOutput, this.checkPidFile, this.checkProcessAlive, this.checkAdminEndpoint, userEndpoints);
            this.startServerHelper = new StartServerHelper(this.programOpts.isTerse(), this.getTimeout(), this.getServerDirs(), this.launcher, signOfLife);
            if (!this.upgrade && this.launcher.needsManualUpgrade()) {
                logger.info(I18N.get("manualUpgradeNeeded"));
                return 1;
            }
            if (!this.upgrade && this.launcher.needsAutoUpgrade()) {
                this.doAutoUpgrade();
            }
            if (this.dryRun) {
                logger.fine("Dump of JVM Invocation line that would be used to launch:");
                List cmd = this.launcher.getCommandLine().toList();
                int indexOfReadStdin = cmd.indexOf("-read-stdin");
                String cmdToLog = IntStream.range(0, cmd.size()).filter(index -> index < indexOfReadStdin || index > indexOfReadStdin + 1).mapToObj(cmd::get).collect(Collectors.joining("\n")) + "\n";
                logger.info(cmdToLog);
                return 0;
            }
            this.doAdminPasswordCheck();
            this.launcher.launch();
            if (this.verbose || this.upgrade || this.watchdog) {
                return this.startServerHelper.talkWithUser();
            }
            String report = this.startServerHelper.waitForServerStart(this.getTimeout());
            logger.info(report);
            return 0;
        }
        catch (GFLauncherException e) {
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
        catch (MiniXmlParserException me) {
            throw new CommandException((Throwable)me);
        }
    }

    @Override
    public final GFLauncher createLauncher() throws GFLauncherException, MiniXmlParserException, CommandException {
        GFLauncher gfLauncher = GFLauncherFactory.getInstance((RuntimeType)this.getType());
        this.launchParameters = gfLauncher.getParameters();
        this.launchParameters.setDomainName(this.getDomainName());
        this.launchParameters.setDomainParentDir(this.getDomainsDir().getPath());
        this.launchParameters.setVerbose(this.verbose || this.upgrade);
        this.launchParameters.setIgnoreOutput(this.printServerOutput == Boolean.FALSE);
        this.launchParameters.setSuspend(this.suspend);
        this.launchParameters.setDebug(this.debug);
        this.launchParameters.setUpgrade(this.upgrade);
        this.launchParameters.setWatchdog(this.watchdog);
        this.launchParameters.setDropInterruptedCommands(this.dropInterruptedCommands);
        this.launchParameters.setRespawnInfo(this.programOpts.getClassName(), this.programOpts.getModulePath(), this.programOpts.getClassPath(), this.respawnArgs());
        this.launchParameters.setAsadminAdminAddress(this.getUserProvidedAdminAddress());
        gfLauncher.setup();
        this.launchParameters.addSecurityToken("AS_ADMIN_MASTERPASSWORD", this.getMasterPassword());
        return gfLauncher;
    }

    public String toString() {
        return ObjectAnalyzer.toStringWithSuper((Object)this);
    }

    private String[] respawnArgs() {
        ArrayList<Object> args = new ArrayList<Object>(15);
        args.addAll(Arrays.asList(this.programOpts.getProgramArguments()));
        args.add(this.getName());
        args.add("--verbose=" + String.valueOf(this.verbose));
        args.add("--watchdog=" + String.valueOf(this.watchdog));
        args.add("--debug=" + String.valueOf(this.debug));
        args.add("--domaindir");
        args.add(this.getDomainsDir().toString());
        if (StartDomainCommand.ok((String)this.getDomainName())) {
            args.add(this.getDomainName());
        }
        logger.log(Level.FINER, "Respawn args: {0}", args);
        return (String[])args.toArray(String[]::new);
    }

    private GFLauncher doAutoUpgrade() throws GFLauncherException, MiniXmlParserException, CommandException {
        logger.info(I18N.get("upgradeNeeded"));
        this.launchParameters.setUpgrade(true);
        this.launcher.setup();
        this.launcher.launch();
        int exitCode = this.waitForAutoUpgradeFinish();
        if (exitCode == 0) {
            logger.info(I18N.get("upgradeSuccessful"));
            return this.createLauncher();
        }
        ProcessStreamDrainer psd = this.launcher.getProcessStreamDrainer();
        String output = psd.getOutErrString();
        if (StartDomainCommand.ok((String)output)) {
            throw new CommandException(I18N.get("upgradeFailedOutput", new Object[]{this.launchParameters.getDomainName(), exitCode, output}));
        }
        throw new CommandException(I18N.get("upgradeFailed", new Object[]{this.launchParameters.getDomainName(), exitCode}));
    }

    private int waitForAutoUpgradeFinish() {
        Process glassFishProcess = this.launcher.getProcess();
        try {
            return glassFishProcess.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.log(Level.SEVERE, "Waiting for the upgrade was interrupted!", e);
            System.exit(-1);
            return -1;
        }
    }

    private void doAdminPasswordCheck() throws CommandException {
        File adminRealmKeyFile = this.launcher.getAdminRealmKeyFile();
        if (adminRealmKeyFile == null) {
            return;
        }
        try {
            String newPassword;
            FileRealmHelper fileRealmHelper = new FileRealmHelper(adminRealmKeyFile);
            if (fileRealmHelper.hasAuthenticatableUser()) {
                return;
            }
            Set adminUsers = fileRealmHelper.getUserNames();
            if (adminUsers == null || adminUsers.isEmpty()) {
                throw new CommandException("no admin users");
            }
            String firstAdminUser = (String)adminUsers.iterator().next();
            CommandModelData.ParamModelData npwo = new CommandModelData.ParamModelData(this.newpwName, String.class, false, null);
            npwo.prompt = I18N.get("new.adminpw", new Object[]{firstAdminUser});
            npwo.promptAgain = I18N.get("new.adminpw.again", new Object[]{firstAdminUser});
            npwo.param._password = true;
            logger.info(I18N.get("new.adminpw.prompt"));
            char[] newPasswordArray = super.getPassword((CommandModel.ParamModel)npwo, null, true);
            String string = newPassword = newPasswordArray == null ? null : new String(newPasswordArray);
            if (newPassword == null) {
                throw new CommandException("The Master Password is required to start the domain.\nNo console, no prompting possible. You should either create the domain\nwith --savemasterpassword=true or provide a password file with the --passwordfile option.");
            }
            fileRealmHelper.updateUser(firstAdminUser, firstAdminUser, newPassword.toCharArray(), null);
            fileRealmHelper.persist();
        }
        catch (IOException ioe) {
            throw new CommandException((Throwable)ioe);
        }
    }
}

