/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.util;

import com.sun.jdo.api.persistence.enhancer.util.ClassPath;
import com.sun.jdo.api.persistence.enhancer.util.ClassPathElement;
import com.sun.jdo.api.persistence.enhancer.util.FilePath;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import com.sun.jdo.api.persistence.enhancer.util.UserException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassFileSource
extends Support {
    private String theOriginalExpectedClassName = null;
    private String theExpectedClassName = null;
    private File classFile = null;
    private ZipFile zipFile = null;
    private InputStream byteCodeStream = null;
    private ClassPathElement sourceElement;
    private long cachedModDate;

    public boolean sameAs(ClassFileSource other) {
        if (this.isZipped()) {
            return other.isZipped() && other.zipFile.getName().equals(this.zipFile.getName());
        }
        if (other.isZipped()) {
            return false;
        }
        if (other.classFile != null && this.classFile != null) {
            return other.classFile.getPath().equals(this.classFile.getPath());
        }
        if (this.byteCodeStream != null) {
            return this.byteCodeStream.equals(other.byteCodeStream);
        }
        return false;
    }

    public boolean isZipped() {
        return this.zipFile != null;
    }

    public boolean isStreamed() {
        return this.byteCodeStream != null;
    }

    public String expectedClassName() {
        return this.theExpectedClassName;
    }

    public void setExpectedClassName(String name) {
        this.theExpectedClassName = name;
    }

    public String containingFilePath() {
        if (this.isZipped()) {
            return this.zipFile.getName();
        }
        if (this.classFile != null) {
            return this.classFile.getPath();
        }
        return null;
    }

    public ClassFileSource(String className, File classFile) {
        this.theExpectedClassName = className;
        this.theOriginalExpectedClassName = className;
        this.classFile = classFile;
    }

    public ClassFileSource(String className, ZipFile zipFile) {
        this.theExpectedClassName = className;
        this.theOriginalExpectedClassName = className;
        this.zipFile = zipFile;
    }

    public ClassFileSource(String className, InputStream byteCodeStream) {
        this.theExpectedClassName = className;
        this.theOriginalExpectedClassName = className;
        this.byteCodeStream = byteCodeStream;
    }

    public ClassFileSource nextSource(String className) {
        if (this.sourceElement != null && this.sourceElement.next() != null) {
            return ClassPath.findClass(className, this.sourceElement.next());
        }
        return null;
    }

    public ClassFileSource friendSource(String className) {
        if (this.isZipped()) {
            return new ClassFileSource(className, this.zipFile);
        }
        String fullPath = FilePath.getAbsolutePath(this.classFile);
        File dir = new File(fullPath.substring(0, fullPath.lastIndexOf(File.separatorChar) + 1));
        File f = new File(dir, this.unpackagedName(className) + ".class");
        return new ClassFileSource(className, f);
    }

    public DataInputStream classFileContents() throws IOException, FileNotFoundException {
        if (this.isZipped()) {
            ZipEntry entry = this.zipFile.getEntry(ClassPath.zipFileNameOf(this.theExpectedClassName));
            if (entry == null) {
                throw new FileNotFoundException("The zip file member " + this.theExpectedClassName + " was not found.");
            }
            return new DataInputStream(this.zipFile.getInputStream(entry));
        }
        if (this.isStreamed()) {
            return new DataInputStream(this.byteCodeStream);
        }
        return new DataInputStream(new BufferedInputStream(new FileInputStream(this.classFile)));
    }

    public long modificationDate() throws FileNotFoundException {
        if (this.cachedModDate == 0L) {
            if (this.isZipped()) {
                ZipEntry entry = this.zipFile.getEntry(ClassPath.zipFileNameOf(this.theOriginalExpectedClassName));
                if (entry == null) {
                    throw new FileNotFoundException("The zip file member was not found.");
                }
                this.cachedModDate = entry.getTime();
            } else if (this.classFile != null) {
                this.cachedModDate = this.classFile.lastModified();
            }
        }
        return this.cachedModDate;
    }

    public void setModificationDate(long date) {
        this.cachedModDate = date;
    }

    void setSourceElement(ClassPathElement cpathElement) {
        this.sourceElement = cpathElement;
    }

    private File computeDestinationDir(File rootDestDir) throws IOException, FileNotFoundException {
        StringBuffer buf = new StringBuffer(rootDestDir.getPath());
        String prevToken = null;
        StringTokenizer parser = new StringTokenizer(this.theExpectedClassName, "/", false);
        while (parser.hasMoreTokens()) {
            if (prevToken != null) {
                buf.append(File.separatorChar);
                buf.append(prevToken);
                File currDir = new File(buf.toString());
                if (!currDir.isDirectory() && !currDir.mkdir()) {
                    throw new UserException(ClassFileSource.getI18N("enhancer.unable_to_create_dir", currDir.getPath()));
                }
            }
            prevToken = parser.nextToken();
        }
        return new File(buf.toString());
    }

    public File computeDestination(File destDir) throws IOException, FileNotFoundException {
        if (destDir != null) {
            File finalDestDir = this.computeDestinationDir(destDir);
            String theFinalClassComponent = "";
            StringTokenizer parser = new StringTokenizer(this.theExpectedClassName, "/", false);
            while (parser.hasMoreTokens()) {
                theFinalClassComponent = parser.nextToken();
            }
            return new File(finalDestDir, theFinalClassComponent + ".class");
        }
        return this.classFile;
    }

    public DataOutputStream getOutputStream(File dest) throws IOException, FileNotFoundException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));
    }

    private String unpackagedName(String className) {
        int idx = className.lastIndexOf(47);
        if (idx < 0) {
            return className;
        }
        return className.substring(idx + 1);
    }
}

