/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsservice;

import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.EnumConverter;
import com.sun.messaging.jmq.jmsservice.JMSPacketProperties;
import com.sun.messaging.jmq.jmsservice.ReverseEnumMap;
import java.util.Map;
import lombok.Generated;

public class JMSServiceReply {
    private JMSPacketProperties properties = null;
    private Status status;

    public JMSServiceReply(Map<? extends String, ? extends Object> replyProps) {
        this.properties = replyProps != null ? new JMSPacketProperties(replyProps) : new JMSPacketProperties();
        this.setStatus();
    }

    public String getErrorCode() {
        if (this.properties == null) {
            return null;
        }
        Object o = this.properties.get("JMQErrorCode");
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public boolean getBooleanProp(String prop) throws NoSuchFieldException {
        Object errMsg = "JMSServiceReply has no return property values";
        if (this.properties != null) {
            try {
                return (Boolean)this.properties.get(prop);
            }
            catch (Exception exception) {
                errMsg = "JMSServiceReply is missing boolean property -" + prop;
            }
        }
        throw new NoSuchFieldException((String)errMsg);
    }

    public int getIntProp(String prop) throws NoSuchFieldException {
        Object errMsg = "JMSServiceReply has no return property values";
        if (this.properties != null) {
            try {
                return (Integer)this.properties.get(prop);
            }
            catch (Exception exception) {
                errMsg = "JMSServiceReply is missing int property -" + prop;
            }
        }
        throw new NoSuchFieldException((String)errMsg);
    }

    public long getLongProp(String prop) throws NoSuchFieldException {
        Object errMsg = "JMSServiceReply has no return property values";
        if (this.properties != null) {
            try {
                Long _tmp = (Long)this.properties.get(prop);
                return _tmp;
            }
            catch (Exception exception) {
                errMsg = "JMSServiceReply is missing long property -" + prop;
            }
        }
        throw new NoSuchFieldException((String)errMsg);
    }

    public String getStringProp(String prop) throws NoSuchFieldException {
        Object errMsg = "JMSServiceReply has no return property values";
        if (this.properties != null) {
            try {
                return (String)this.properties.get(prop);
            }
            catch (Exception exception) {
                errMsg = "JMSServiceReply is missing string property -" + prop;
            }
        }
        throw new NoSuchFieldException((String)errMsg);
    }

    public String getJMQVersion() throws NoSuchFieldException {
        return this.getStringProp("JMQVersion");
    }

    public long getJMQConnectionID() throws NoSuchFieldException {
        return this.getLongProp("JMQConnectionID");
    }

    public boolean getJMQHA() {
        boolean _JMQHA = false;
        try {
            _JMQHA = this.getBooleanProp("JMQHA");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return _JMQHA;
    }

    public String getJMQClusterID() {
        String _JMQClusterID = null;
        try {
            _JMQClusterID = this.getStringProp("JMQClusterID");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return _JMQClusterID;
    }

    public long getJMQMaxMsgBytes() throws NoSuchFieldException {
        return this.getLongProp("JMQMaxMsgBytes");
    }

    public String getJMQBrokerList() {
        String _JMQBrokerList = null;
        try {
            _JMQBrokerList = this.getStringProp("JMQBrokerList");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return _JMQBrokerList;
    }

    public long getJMQSessionID() throws NoSuchFieldException {
        return this.getLongProp("JMQSessionID");
    }

    public String getJMQDestination() {
        String _JMQDestination = null;
        try {
            _JMQDestination = this.getStringProp("JMQDestination");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return _JMQDestination;
    }

    public Destination.Type getJMQDestType() throws NoSuchFieldException {
        int _DestinationType = this.getIntProp("JMQDestType");
        if (_DestinationType == 1) {
            return Destination.Type.QUEUE;
        }
        return Destination.Type.TOPIC;
    }

    public boolean getJMQCanCreate() {
        boolean _JMQCanCreate = false;
        try {
            _JMQCanCreate = this.getBooleanProp("JMQCanCreate");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return _JMQCanCreate;
    }

    public long getJMQProducerID() throws NoSuchFieldException {
        return this.getLongProp("JMQProducerID");
    }

    public long getJMQConsumerID() throws NoSuchFieldException {
        return this.getLongProp("JMQConsumerID");
    }

    public long getJMQTransactionID() throws NoSuchFieldException {
        return this.getLongProp("JMQTransactionID");
    }

    private void setStatus() {
        this.status = Status.UNKNOWN;
        try {
            if (this.properties != null) {
                try {
                    this.status = (Status)this.properties.get("JMQStatus");
                }
                catch (ClassCastException cce) {
                    Integer _tmp = (Integer)this.properties.get("JMQStatus");
                    int _replyCode = _tmp;
                    this.status = Status.UNKNOWN.convert(_replyCode);
                }
            }
        }
        catch (Exception e) {
            System.err.println("JMSServiceReply:setStatus:Exception:" + e.getMessage());
        }
    }

    @Generated
    public JMSPacketProperties getProperties() {
        return this.properties;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    public static enum Status implements EnumConverter<Status>
    {
        OK(200),
        CREATED(201),
        MULTIPLE_CHOICES(300),
        MOVED_PERMENANTLY(301),
        NOT_MODIFIED(304),
        BAD_REQUEST(400),
        UNATUHORIZED(401),
        PAYMENT_REQUIRED(402),
        FORBIDDEN(403),
        NOT_FOUND(404),
        NOT_ALLOWED(405),
        TIMEOUT(408),
        CONFLICT(409),
        PRECONDITION_FAILED(412),
        INVALID_LOGIN(413),
        RESOURCE_FULL(414),
        ENTITY_TOO_LARGE(423),
        ERROR(500),
        NOT_IMPLEMENTED(501),
        UNAVAILABLE(503),
        BAD_VERSION(505),
        UNKNOWN(999);

        private static ReverseEnumMap<Status> map;
        private final int _statusCode;

        private Status(int statusCode) {
            this._statusCode = statusCode;
        }

        public int getStatusCode() {
            return this._statusCode;
        }

        @Override
        public int convert() {
            return this._statusCode;
        }

        @Override
        public Status convert(int val) {
            return map.get(val);
        }

        static {
            map = new ReverseEnumMap<Status>(Status.class);
        }
    }
}

