/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.util;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.security.secconv.WSSecureConversationRuntimeException;
import com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken;
import com.sun.xml.ws.security.opt.impl.util.LocalStringManagerImpl;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import jakarta.xml.soap.Detail;
import jakarta.xml.soap.DetailEntry;
import jakarta.xml.soap.SOAPConstants;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.xml.namespace.QName;

public final class SOAPUtil {
    private static boolean enableFaultDetail = false;
    private static final String WSS_DEBUG_PROPERTY = "com.sun.xml.wss.debug";
    private static final String ENABLE_FAULT_DETAIL = "FaultDetail";
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SOAPUtil.class);
    private static final String localizedGenericError;

    public static SOAPFaultException getSOAPFaultException(QName faultCode, WSSecureConversationRuntimeException wsre, SOAPFactory soapFactory, SOAPVersion sOAPVersion) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static boolean isEnableFaultDetail() {
        return enableFaultDetail;
    }

    public static String getLocalizedGenericError() {
        return localizedGenericError;
    }

    private SOAPUtil() {
    }

    public static String getIdFromFragmentRef(String ref) {
        char start = ref.charAt(0);
        if (start == '#') {
            return ref.substring(1);
        }
        return ref;
    }

    public static X509Certificate getCertificateFromToken(BinarySecurityToken bst) throws XWSSecurityException {
        byte[] data = bst.getTokenValue();
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(data));
        }
        catch (Exception e) {
            throw new XWSSecurityException("Unable to create X509Certificate from data");
        }
    }

    public static WssSoapFaultException newSOAPFaultException(QName faultCode, String faultstring, Throwable th) {
        if (!SOAPUtil.isEnableFaultDetail()) {
            return new WssSoapFaultException(MessageConstants.WSSE_INVALID_SECURITY, SOAPUtil.getLocalizedGenericError(), null, null);
        }
        WssSoapFaultException sfe = new WssSoapFaultException(faultCode, faultstring, null, null);
        sfe.initCause(th);
        return sfe;
    }

    public static WssSoapFaultException newSOAPFaultException(QName faultCode, String faultstring, Throwable th, boolean faultDetail) {
        if (!faultDetail) {
            return new WssSoapFaultException(MessageConstants.WSSE_INVALID_SECURITY, SOAPUtil.getLocalizedGenericError(), null, null);
        }
        WssSoapFaultException sfe = new WssSoapFaultException(faultCode, faultstring, null, null);
        sfe.initCause(th);
        return sfe;
    }

    protected static SOAPFault getSOAPFault(WssSoapFaultException sfe, SOAPFactory soapFactory, SOAPVersion version) {
        SOAPFault fault;
        String reasonText = sfe.getFaultString();
        if (reasonText == null) {
            reasonText = sfe.getMessage() != null ? sfe.getMessage() : "";
        }
        try {
            if (version == SOAPVersion.SOAP_12) {
                fault = soapFactory.createFault(reasonText, SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(sfe.getFaultCode());
            } else {
                fault = soapFactory.createFault(reasonText, sfe.getFaultCode());
            }
        }
        catch (Exception e) {
            throw new XWSSecurityRuntimeException(e);
        }
        return fault;
    }

    protected static SOAPFault getSOAPFault(QName faultCode, String faultString, SOAPFactory soapFactory, SOAPVersion version) {
        SOAPFault fault;
        try {
            if (version == SOAPVersion.SOAP_12) {
                fault = soapFactory.createFault(faultString, SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(faultCode);
            } else {
                fault = soapFactory.createFault(faultString, faultCode);
            }
        }
        catch (Exception e) {
            throw new XWSSecurityRuntimeException(e);
        }
        return fault;
    }

    public static SOAPFaultException getSOAPFaultException(WssSoapFaultException ex, SOAPFactory factory, SOAPVersion version) {
        SOAPFault fault = SOAPUtil.getSOAPFault(ex, factory, version);
        if (!SOAPUtil.isEnableFaultDetail()) {
            return SOAPUtil.createSOAPFault(fault, ex);
        }
        Throwable cause = ex.getCause();
        SOAPUtil.setFaultDetail(fault, cause);
        return SOAPUtil.createSOAPFault(fault, ex);
    }

    public static SOAPFaultException getSOAPFaultException(QName faultCode, Exception ex, SOAPFactory factory, SOAPVersion version) {
        String msg = SOAPUtil.getExceptionMessage(ex);
        SOAPFault fault = SOAPUtil.getSOAPFault(faultCode, msg, factory, version);
        if (!SOAPUtil.isEnableFaultDetail()) {
            return SOAPUtil.createSOAPFault(fault, ex);
        }
        SOAPUtil.setFaultDetail(fault, ex);
        return SOAPUtil.createSOAPFault(fault, ex);
    }

    public static SOAPFaultException getSOAPFaultException(Exception ex, SOAPFactory factory, SOAPVersion version) {
        String msg = SOAPUtil.getExceptionMessage(ex);
        SOAPFault fault = SOAPUtil.getSOAPFault(MessageConstants.WSSE_INVALID_SECURITY, msg, factory, version);
        if (!SOAPUtil.isEnableFaultDetail()) {
            return SOAPUtil.createSOAPFault(fault, ex);
        }
        SOAPUtil.setFaultDetail(fault, ex);
        return SOAPUtil.createSOAPFault(fault, ex);
    }

    private static SOAPFaultException createSOAPFault(SOAPFault fault, Throwable cause) {
        SOAPFaultException sfe = new SOAPFaultException(fault);
        if (SOAPUtil.isEnableFaultDetail()) {
            sfe.initCause(cause);
        } else {
            sfe.initCause((Throwable)new Exception());
        }
        return sfe;
    }

    private static void setFaultDetail(SOAPFault fault, Throwable cause) {
        try {
            Detail detail = fault.addDetail();
            QName name = new QName("https://xwss.dev.java.net", ENABLE_FAULT_DETAIL, "xwssfault");
            DetailEntry entry = detail.addDetailEntry(name);
            String exception = "Cause Not Set";
            if (cause != null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintWriter s = new PrintWriter(bos);
                cause.printStackTrace(s);
                s.flush();
                exception = bos.toString();
            }
            entry.addTextNode(exception);
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }

    private static String getExceptionMessage(Throwable ex) {
        if (!SOAPUtil.isEnableFaultDetail()) {
            return SOAPUtil.getLocalizedGenericError();
        }
        String msg = ex.getMessage();
        if (msg == null) {
            msg = ex.getClass().getName();
        }
        return msg;
    }

    static {
        String debugFlag = System.getProperty(WSS_DEBUG_PROPERTY);
        if (debugFlag != null && debugFlag.contains(ENABLE_FAULT_DETAIL)) {
            enableFaultDetail = true;
        }
        localizedGenericError = localStrings.getLocalString("generic.validation.error", "Invalid Security Header");
    }
}

