/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.appclient;

import com.sun.enterprise.security.common.Util;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.appclient.client.acc.config.ClientContainer;
import org.glassfish.appclient.client.acc.config.MessageSecurityConfig;
import org.glassfish.appclient.client.acc.config.Property;
import org.glassfish.appclient.client.acc.config.ProviderConfig;
import org.glassfish.appclient.client.acc.config.RequestPolicy;
import org.glassfish.appclient.client.acc.config.ResponsePolicy;
import org.glassfish.epicyro.config.factory.ConfigParser;
import org.glassfish.epicyro.config.helper.AuthMessagePolicy;
import org.glassfish.epicyro.data.AuthModuleConfig;
import org.glassfish.epicyro.data.AuthModulesLayerConfig;
import org.glassfish.internal.api.Globals;

public class ConfigXMLParser
implements ConfigParser {
    private static final System.Logger LOG = System.getLogger(ConfigXMLParser.class.getName());
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{\\{(.*?)}}|\\$\\{(.*?)}");
    private final Map<String, AuthModulesLayerConfig> authModuleLayers = new HashMap<String, AuthModulesLayerConfig>();
    private final Set<String> layersWithDefault = new HashSet<String>();
    private List<MessageSecurityConfig> msgSecConfigs;
    private static final String ACC_XML = "glassfish-acc.xml.url";

    public void initialize(List<MessageSecurityConfig> msgConfigs) throws IOException {
        this.msgSecConfigs = msgConfigs;
        if (this.msgSecConfigs != null) {
            this.processClientConfigContext(this.authModuleLayers);
        }
    }

    private void processClientConfigContext(Map<String, AuthModulesLayerConfig> newConfig) throws IOException {
        String authLayer = null;
        List<MessageSecurityConfig> msgConfigs = this.msgSecConfigs;
        for (MessageSecurityConfig messageSecurityConfig : msgConfigs) {
            authLayer = this.parseInterceptEntry(messageSecurityConfig, newConfig);
            List providerConfigurations = messageSecurityConfig.getProviderConfig();
            for (ProviderConfig providerConfiguration : providerConfigurations) {
                this.parseIDEntry(providerConfiguration, newConfig, authLayer);
            }
        }
    }

    public Map<String, AuthModulesLayerConfig> getAuthModuleLayers() {
        return this.authModuleLayers;
    }

    public Set<String> getLayersWithDefault() {
        return this.layersWithDefault;
    }

    private String parseInterceptEntry(MessageSecurityConfig msgConfig, Map<String, AuthModulesLayerConfig> newConfig) throws IOException {
        AuthModulesLayerConfig authModulesLayerConfig;
        MessageSecurityConfig clientMsgSecConfig = msgConfig;
        String authLayer = clientMsgSecConfig.getAuthLayer();
        String defaultServerID = clientMsgSecConfig.getDefaultProvider();
        String defaultClientID = clientMsgSecConfig.getDefaultClientProvider();
        LOG.log(System.Logger.Level.DEBUG, "AuthLayer Entry:\n AuthLayer: {0}\n defaultServerID: {1}\n defaultClientID: {2}", authLayer, defaultServerID, defaultClientID);
        if (defaultServerID != null || defaultClientID != null) {
            this.layersWithDefault.add(authLayer);
        }
        if ((authModulesLayerConfig = newConfig.get(authLayer)) != null) {
            throw new IOException("found multiple MessageSecurityConfig entries with the same auth-layer");
        }
        authModulesLayerConfig = new AuthModulesLayerConfig(defaultClientID, defaultServerID, null);
        newConfig.put(authLayer, authModulesLayerConfig);
        return authLayer;
    }

    private void parseIDEntry(ProviderConfig providerConfig, Map<String, AuthModulesLayerConfig> newConfig, String authLayer) throws IOException {
        String id = providerConfig.getProviderId();
        String type = providerConfig.getProviderType();
        String moduleClass = providerConfig.getClassName();
        MessagePolicy requestPolicy = this.parsePolicy(providerConfig.getRequestPolicy());
        MessagePolicy responsePolicy = this.parsePolicy(providerConfig.getResponsePolicy());
        HashMap<String, String> options = new HashMap<String, String>();
        List properties = providerConfig.getProperty();
        for (Property property : properties) {
            try {
                options.put(property.getName(), this.expand(property.getValue()));
            }
            catch (IllegalStateException ee) {
                LOG.log(System.Logger.Level.WARNING, "SEC1200: Unable to expand provider property value, unexpanded value passed to provider.");
                options.put(property.getName(), property.getValue());
            }
        }
        LOG.log(System.Logger.Level.DEBUG, "ID Entry: \n module class: {0}\n id: {1}\n type: {2}\n request policy: {3}\n response policy: {4}\n options: {5}", moduleClass, id, type, requestPolicy, responsePolicy, options);
        AuthModuleConfig authModuleConfig = new AuthModuleConfig(type, moduleClass, requestPolicy, responsePolicy, options);
        AuthModulesLayerConfig authModulesLayerConfig = newConfig.get(authLayer);
        if (authModulesLayerConfig == null) {
            throw new IOException("authLayer entry for " + authLayer + " must be specified before ID entries");
        }
        if (authModulesLayerConfig.getAuthModules() == null) {
            authModulesLayerConfig.setIdMap(new HashMap());
        }
        authModulesLayerConfig.getAuthModules().put(id, authModuleConfig);
    }

    private String expand(String rawProperty) {
        Matcher propertyMatcher = PROPERTY_PATTERN.matcher(rawProperty);
        StringBuilder propertyBuilder = new StringBuilder();
        while (propertyMatcher.find()) {
            if (propertyMatcher.group(1) != null) {
                propertyMatcher.appendReplacement(propertyBuilder, Matcher.quoteReplacement(propertyMatcher.group()));
                continue;
            }
            String replacement = System.getProperty(propertyMatcher.group(2));
            if (replacement == null) {
                throw new IllegalStateException("No system property for " + propertyMatcher.group(2));
            }
            propertyMatcher.appendReplacement(propertyBuilder, Matcher.quoteReplacement(replacement));
        }
        propertyMatcher.appendTail(propertyBuilder);
        return propertyBuilder.toString();
    }

    private MessagePolicy parsePolicy(Object policy) {
        if (policy == null) {
            return null;
        }
        String authSource = null;
        String authRecipient = null;
        if (policy instanceof RequestPolicy) {
            RequestPolicy clientRequestPolicy = (RequestPolicy)policy;
            authSource = clientRequestPolicy.getAuthSource();
            authRecipient = clientRequestPolicy.getAuthRecipient();
        } else if (policy instanceof ResponsePolicy) {
            ResponsePolicy clientResponsePolicy = (ResponsePolicy)policy;
            authSource = clientResponsePolicy.getAuthSource();
            authRecipient = clientResponsePolicy.getAuthRecipient();
        }
        return AuthMessagePolicy.getMessagePolicy((String)authSource, authRecipient);
    }

    public void initialize(Object config) throws IOException {
        String glassFishAccXml = System.getProperty(ACC_XML, "glassfish-acc.xml");
        List msgconfigs = null;
        if (Globals.getDefaultHabitat() == null && glassFishAccXml != null && new File(glassFishAccXml).exists()) {
            try (FileInputStream is = new FileInputStream(glassFishAccXml);){
                ClientContainer clientContainer = (ClientContainer)JAXBContext.newInstance((Class[])new Class[]{ClientContainer.class}).createUnmarshaller().unmarshal((InputStream)is);
                msgconfigs = clientContainer.getMessageSecurityConfig();
            }
            catch (JAXBException ex) {
                LOG.log(System.Logger.Level.ERROR, "Failed to parse glassfish-acc.xml", (Throwable)ex);
            }
        } else {
            msgconfigs = (List)Util.getInstance().getAppClientMsgSecConfigs();
        }
        this.initialize(msgconfigs);
    }
}

