/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.enterprise.util.i18n.StringManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.security.jarsigner.JarSigner;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ASJarSigner
implements PostConstruct {
    public static final String USER_SPECIFIED_ALIAS_PROPERTYNAME = "com.sun.aas.jws.signing.alias";
    private static final String DEFAULT_ALIAS_VALUE = "s1as";
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA-256";
    private static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final StringManager localStrings = StringManager.getManager(ASJarSigner.class);
    @Inject
    private SecuritySupport securitySupport;
    private Logger logger;

    public void postConstruct() {
        this.logger = Logger.getLogger("jakarta.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages");
    }

    public long signJar(File unsignedJar, File signedJar, String alias, Attributes attrs) throws Exception {
        try (BufferedOutputStream zout = new BufferedOutputStream(new FileOutputStream(signedJar));){
            long l = this.signJar(unsignedJar, zout, alias, attrs, Collections.emptyMap());
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long signJar(File unsignedJar, OutputStream signedJar, String alias, Attributes attrs, Map<String, byte[]> additionalContent) throws IllegalStateException {
        if (alias == null) {
            alias = DEFAULT_ALIAS_VALUE;
        }
        long startTime = System.currentTimeMillis();
        long duration = 0L;
        ASJarSigner aSJarSigner = this;
        synchronized (aSJarSigner) {
            try {
                JarSigner signer = this.createJarSigner(alias);
                try (JarFile jarFile = new JarFile(unsignedJar);){
                    signer.sign(jarFile, signedJar);
                }
            }
            catch (Exception e) {
                try {
                    throw new IllegalStateException(localStrings.getString("jws.sign.errorSigning", (Object)unsignedJar.getAbsolutePath(), (Object)alias), e);
                }
                catch (Throwable throwable) {
                    duration = System.currentTimeMillis() - startTime;
                    this.logger.log(Level.FINE, "Signing {0} took {1} ms", new Object[]{unsignedJar.getAbsolutePath(), duration});
                    throw throwable;
                }
            }
            duration = System.currentTimeMillis() - startTime;
            this.logger.log(Level.FINE, "Signing {0} took {1} ms", new Object[]{unsignedJar.getAbsolutePath(), duration});
        }
        return duration;
    }

    private JarSigner createJarSigner(String alias) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        Certificate[] certificates = null;
        PrivateKey privateKey = null;
        KeyStore[] keyStores = this.securitySupport.getKeyStores();
        for (int i = 0; i < keyStores.length && ((privateKey = this.securitySupport.getPrivateKeyForAlias(alias, i)) == null || (certificates = keyStores[i].getCertificateChain(alias)) == null || certificates.length <= 0); ++i) {
        }
        if (certificates == null) {
            throw new IllegalStateException("No certificates available for the alias: " + alias);
        }
        CertPath certPath = CertificateFactory.getInstance("X.509").generateCertPath(Arrays.asList(certificates));
        return new JarSigner.Builder(privateKey, certPath).digestAlgorithm(DEFAULT_DIGEST_ALGORITHM).signatureAlgorithm(DEFAULT_SIGNATURE_ALGORITHM).build();
    }

    public static class ASJarSignerException
    extends Exception {
        public ASJarSignerException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

