/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.readers.InputException;
import org.glassfish.admin.rest.readers.XmlInputObject;

@Consumes(value={"application/xml"})
@Provider
public class XmlHashMapProvider
extends ProviderUtil
implements MessageBodyReader<HashMap<String, String>> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(HashMap.class);
    }

    public HashMap<String, String> readFrom(Class<HashMap<String, String>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream in) throws IOException {
        try {
            XmlInputObject xmlObject = new XmlInputObject(in);
            return XmlHashMapProvider.getStringMap((HashMap)xmlObject.initializeMap());
        }
        catch (InputException exception) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("error", "Entity Parsing Error: " + exception.getMessage());
            return map;
        }
    }
}

