/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jnosql.nosql.metadata.reflection;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.nosql.Column;
import jakarta.nosql.DiscriminatorColumn;
import jakarta.nosql.DiscriminatorValue;
import jakarta.nosql.Entity;
import jakarta.nosql.Id;
import jakarta.nosql.Inheritance;
import jakarta.nosql.MappedSuperclass;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.jnosql.mapping.metadata.InheritanceMetadata;
import org.glassfish.main.jnosql.nosql.metadata.reflection.ConstructorComparable;
import org.glassfish.main.jnosql.nosql.metadata.reflection.ConstructorException;
import org.glassfish.main.jnosql.nosql.metadata.reflection.StringUtils;

@ApplicationScoped
public class Reflections {
    private static final Logger LOGGER = Logger.getLogger(Reflections.class.getName());
    private static final Predicate<String> IS_ID_ANNOTATION = Id.class.getName()::equals;
    private static final Predicate<String> IS_COLUMN_ANNOTATION = Column.class.getName()::equals;
    private static final Predicate<String> IS_NOSQL_ANNOTATION = IS_ID_ANNOTATION.or(IS_COLUMN_ANNOTATION);

    Object getValue(Object object, Field field) {
        try {
            return field.get(object);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINEST, "There is an issue with returning value from this field.", exception);
            return null;
        }
    }

    boolean setValue(Object object, Field field, Object value) {
        try {
            field.set(object, value);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINEST, "There is an issue with setting value from this field.", exception);
            return false;
        }
        return true;
    }

    public static <T> T newInstance(Constructor<T> constructor) {
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINEST, "There is an issue to creating an entity from this constructor", exception);
            return null;
        }
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            Constructor<T> constructor = Reflections.getConstructor(type);
            return Reflections.newInstance(constructor);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINEST, "There is an issue to creating an entity from this constructor", exception);
            return null;
        }
    }

    void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> type) {
        Predicate<Constructor> defaultConstructorPredicate = c -> c.getParameterCount() == 0;
        Predicate<Constructor> customConstructorPredicate = c -> {
            for (Parameter parameter : c.getParameters()) {
                if (!Reflections.hasNoSQLAnnotation(parameter)) continue;
                return true;
            }
            return false;
        };
        List<Constructor> constructors = Stream.of(type.getDeclaredConstructors()).filter(defaultConstructorPredicate.or(customConstructorPredicate)).toList();
        if (constructors.isEmpty()) {
            throw new ConstructorException(type);
        }
        Optional<Constructor> publicConstructor = constructors.stream().sorted(ConstructorComparable.INSTANCE).filter(c -> Modifier.isPublic(c.getModifiers())).findFirst();
        if (publicConstructor.isPresent()) {
            return publicConstructor.get();
        }
        Constructor constructor = constructors.get(0);
        constructor.setAccessible(true);
        return constructor;
    }

    static boolean hasNoSQLAnnotation(Parameter parameter) {
        return parameter != null && Arrays.stream(parameter.getAnnotations()).map(Annotation::annotationType).map(Class::getName).anyMatch(IS_NOSQL_ANNOTATION);
    }

    String getEntityName(Class<?> entity) {
        Objects.requireNonNull(entity, "class entity is required");
        if (this.isInheritance(entity)) {
            return this.readEntity(entity.getSuperclass());
        }
        return this.readEntity(entity);
    }

    List<Field> getFields(Class<?> type) {
        Objects.requireNonNull(type, "class entity is required");
        ArrayList<Field> fields = new ArrayList<Field>();
        if (this.isMappedSuperclass(type)) {
            fields.addAll(this.getFields(type.getSuperclass()));
        }
        Predicate<Field> hasColumnAnnotation = f -> f.getAnnotation(Column.class) != null;
        Predicate<Field> hasIdAnnotation = f -> f.getAnnotation(Id.class) != null;
        Stream.of(type.getDeclaredFields()).filter(hasColumnAnnotation.or(hasIdAnnotation)).forEach(fields::add);
        return fields;
    }

    boolean isMappedSuperclass(Class<?> type) {
        Objects.requireNonNull(type, "class entity is required");
        Class<?> superclass = type.getSuperclass();
        return superclass.getAnnotation(MappedSuperclass.class) != null || superclass.getAnnotation(Inheritance.class) != null;
    }

    boolean isIdField(Field field) {
        Objects.requireNonNull(field, "field is required");
        return field.getAnnotation(Id.class) != null;
    }

    String getColumnName(Field field) {
        Objects.requireNonNull(field, "field is required");
        return Optional.ofNullable(field.getAnnotation(Column.class)).map(Column::value).filter(StringUtils::isNotBlank).orElse(field.getName());
    }

    String getIdName(Field field) {
        Objects.requireNonNull(field, "field is required");
        return Optional.ofNullable(field.getAnnotation(Id.class)).map(Id::value).filter(StringUtils::isNotBlank).orElse(field.getName());
    }

    Optional<InheritanceMetadata> getInheritance(Class<?> type) {
        Objects.requireNonNull(type, "entity is required");
        if (this.isInheritance(type)) {
            Class<?> parent = type.getSuperclass();
            String discriminatorColumn = this.getDiscriminatorColumn(parent);
            String discriminatorValue = this.getDiscriminatorValue(type);
            return Optional.of(new InheritanceMetadata(discriminatorValue, discriminatorColumn, parent, type));
        }
        if (type.getAnnotation(Inheritance.class) != null) {
            String discriminatorColumn = this.getDiscriminatorColumn(type);
            String discriminatorValue = this.getDiscriminatorValue(type);
            return Optional.of(new InheritanceMetadata(discriminatorValue, discriminatorColumn, type, type));
        }
        return Optional.empty();
    }

    boolean hasInheritanceAnnotation(Class<?> entity) {
        Objects.requireNonNull(entity, "entity is required");
        return entity.getAnnotation(Inheritance.class) != null;
    }

    public String getUDTName(Field field) {
        Objects.requireNonNull(field, "field is required");
        return Optional.ofNullable(field.getAnnotation(Column.class)).map(Column::udt).filter(StringUtils::isNotBlank).orElse(null);
    }

    public static Optional<ParameterizedType> findParameterizedType(Type type, Class<?> parentType) {
        Class rawClass;
        ParameterizedType parameterizedType;
        Type[] typeArray;
        if (type instanceof ParameterizedType && (typeArray = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class && parentType.isAssignableFrom(rawClass = (Class)typeArray)) {
            return Optional.of(parameterizedType);
        }
        if (type instanceof Class) {
            Optional<ParameterizedType> superResult;
            Class classType = (Class)type;
            Type superType = classType.getGenericSuperclass();
            if (superType != null && (superResult = Reflections.findParameterizedType(superType, parentType)).isPresent()) {
                return superResult;
            }
            for (Type superInterface : classType.getGenericInterfaces()) {
                Optional<ParameterizedType> superResult2 = Reflections.findParameterizedType(superInterface, parentType);
                if (!superResult2.isPresent()) continue;
                return superResult2;
            }
        }
        return Optional.empty();
    }

    private String getDiscriminatorColumn(Class<?> parent) {
        return Optional.ofNullable(parent.getAnnotation(DiscriminatorColumn.class)).map(DiscriminatorColumn::value).orElse("dtype");
    }

    private String getDiscriminatorValue(Class<?> entity) {
        return Optional.ofNullable(entity.getAnnotation(DiscriminatorValue.class)).map(DiscriminatorValue::value).orElse(entity.getSimpleName());
    }

    private String readEntity(Class<?> entity) {
        return Optional.ofNullable(entity.getAnnotation(Entity.class)).map(Entity::value).filter(StringUtils::isNotBlank).orElse(entity.getSimpleName());
    }

    private boolean isInheritance(Class<?> entity) {
        Class<?> superclass = entity.getSuperclass();
        return Optional.ofNullable(superclass).map(s -> s.getAnnotation(Inheritance.class)).isPresent();
    }
}

