/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.spi.ManagedConnectionImpl;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource {
    XAResource xaResource;
    ManagedConnectionImpl managedConnectionImpl;

    public XAResourceImpl(XAResource xaResource, ManagedConnectionImpl managedConnection) {
        this.xaResource = xaResource;
        this.managedConnectionImpl = managedConnection;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.xaResource.commit(xid, onePhase);
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Exception e) {
            throw new XAException(e.getMessage());
        }
        finally {
            this.managedConnectionImpl.transactionCompleted();
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.xaResource.end(xid, flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.xaResource.forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this.xaResource.isSameRM(xaResource);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            int result = this.xaResource.prepare(xid);
            if (result == 3) {
                this.managedConnectionImpl.transactionCompleted();
            }
            return result;
        }
        catch (XAException xae) {
            this.managedConnectionImpl.transactionCompleted();
            throw xae;
        }
        catch (Exception e) {
            this.managedConnectionImpl.transactionCompleted();
            throw new XAException(e.getMessage());
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.xaResource.recover(flag);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.xaResource.rollback(xid);
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Exception e) {
            throw new XAException(e.getMessage());
        }
        finally {
            this.managedConnectionImpl.transactionCompleted();
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaResource.setTransactionTimeout(seconds);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.managedConnectionImpl.transactionStarted();
        this.xaResource.start(xid, flags);
    }
}

