/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import jakarta.decorator.Decorator;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.inject.spi.ProducerFactory;
import org.jboss.weld.bean.AbstractSyntheticBean;
import org.jboss.weld.bean.SyntheticClassBean;
import org.jboss.weld.bean.SyntheticDecorator;
import org.jboss.weld.bean.SyntheticProducerBean;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

public class SyntheticBeanFactory {
    private SyntheticBeanFactory() {
    }

    public static <T> AbstractSyntheticBean<T> create(BeanAttributes<T> attributes, Class<T> beanClass, InjectionTargetFactory<T> factory, BeanManagerImpl manager) {
        if (attributes.getStereotypes().contains(Decorator.class)) {
            return SyntheticBeanFactory.createDecorator(attributes, beanClass, factory, manager);
        }
        return SyntheticBeanFactory.createClassBean(attributes, beanClass, factory, manager);
    }

    public static <T, X> AbstractSyntheticBean<T> create(BeanAttributes<T> attributes, Class<X> beanClass, ProducerFactory<X> factory, BeanManagerImpl manager) {
        return SyntheticBeanFactory.createProducerBean(attributes, beanClass, factory, manager);
    }

    private static <T> AbstractSyntheticBean<T> createClassBean(BeanAttributes<T> attributes, Class<T> beanClass, InjectionTargetFactory<T> factory, BeanManagerImpl manager) {
        if (Reflections.isSerializable(beanClass)) {
            return new PassivationCapableSyntheticClassBean<T>(attributes, beanClass, factory, manager);
        }
        return new SyntheticClassBean<T>(attributes, beanClass, factory, manager);
    }

    private static <T> AbstractSyntheticBean<T> createDecorator(BeanAttributes<T> attributes, Class<T> beanClass, InjectionTargetFactory<T> factory, BeanManagerImpl manager) {
        if (Reflections.isSerializable(beanClass)) {
            return new PassivationCapableSyntheticDecorator<T>(attributes, beanClass, factory, manager);
        }
        return new SyntheticDecorator<T>(attributes, beanClass, factory, manager);
    }

    private static <T, X> AbstractSyntheticBean<T> createProducerBean(BeanAttributes<T> attributes, Class<X> beanClass, ProducerFactory<X> factory, BeanManagerImpl manager) {
        return new SyntheticProducerBean<T, X>(attributes, beanClass, factory, manager);
    }

    private static class PassivationCapableSyntheticClassBean<T>
    extends SyntheticClassBean<T>
    implements PassivationCapable {
        protected PassivationCapableSyntheticClassBean(BeanAttributes<T> attributes, Class<T> beanClass, InjectionTargetFactory<T> factory, BeanManagerImpl manager) {
            super(attributes, beanClass, factory, manager);
        }
    }

    private static class PassivationCapableSyntheticDecorator<T>
    extends SyntheticDecorator<T>
    implements PassivationCapable {
        protected PassivationCapableSyntheticDecorator(BeanAttributes<T> attributes, Class<T> beanClass, InjectionTargetFactory<T> factory, BeanManagerImpl manager) {
            super(attributes, beanClass, factory, manager);
        }
    }
}

