/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.AbstractJExpr;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.JArrayExpr;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.NewDimJArrayExpr;
import org.jboss.jdeparser.NewUndimJArrayExpr;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.StaticRefJExpr;
import org.jboss.jdeparser.Tokens$;

class ArrayJType
extends AbstractJType {
    private final AbstractJType elementType;
    private StaticRefJExpr classExpr;

    ArrayJType(AbstractJType elementType) {
        this.elementType = elementType;
    }

    @Override
    public JType elementType() {
        return this.elementType;
    }

    @Override
    void writeDirect(SourceFileWriter sourceFileWriter) throws IOException {
        sourceFileWriter.write(this.elementType);
        sourceFileWriter.write(Tokens$.PUNCT.BRACKET.OPEN);
        sourceFileWriter.write(Tokens$.PUNCT.BRACKET.CLOSE);
    }

    @Override
    String qualifiedName() {
        return this.elementType.qualifiedName();
    }

    @Override
    public int hashCode() {
        return this.elementType.hashCode() ^ 0xEE55EE5C;
    }

    @Override
    boolean equals(AbstractJType other) {
        return other instanceof ArrayJType && this.elementType.equals(((ArrayJType)other).elementType);
    }

    @Override
    public JExpr _new(JExpr dim) {
        return new NewDimJArrayExpr(this, AbstractJExpr.of(dim));
    }

    @Override
    public JArrayExpr _newArray() {
        return new NewUndimJArrayExpr(this);
    }

    @Override
    public String simpleName() {
        return this.elementType.simpleName();
    }

    @Override
    public String toString() {
        return this.elementType.toString() + "[]";
    }

    @Override
    public JExpr _class() {
        StaticRefJExpr expr = this.classExpr;
        if (expr == null) {
            expr = this.classExpr = new StaticRefJExpr(this, "class");
        }
        return expr;
    }
}

