/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.main.jul.handler.LogRecordBuffer;
import org.glassfish.main.jul.record.GlassFishLogRecord;
import org.glassfish.main.jul.record.MessageResolver;

public class LogCollectorHandler
extends Handler {
    private static final MessageResolver RESOLVER = new MessageResolver();
    private final LogRecordBuffer buffer;
    private final Logger logger;

    public LogCollectorHandler(Logger loggerToFollow) {
        this(loggerToFollow, 100, 5);
    }

    public LogCollectorHandler(Logger loggerToFollow, int capacity, int maxWait) {
        this.buffer = new LogRecordBuffer(capacity, maxWait);
        this.logger = loggerToFollow;
        this.logger.addHandler(this);
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            this.buffer.add(RESOLVER.resolve(record));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.logger.removeHandler(this);
        this.reset();
    }

    public int getSize() {
        return this.buffer.getSize();
    }

    public GlassFishLogRecord pop() {
        return this.buffer.poll();
    }

    public List<GlassFishLogRecord> getAll() {
        GlassFishLogRecord record;
        ArrayList<GlassFishLogRecord> list = new ArrayList<GlassFishLogRecord>(this.buffer.getSize());
        while ((record = this.buffer.poll()) != null) {
            list.add(record);
        }
        return list;
    }

    public <R> List<R> getAll(Function<LogRecord, R> mappingFunction) {
        return this.getAll().stream().map(mappingFunction).collect(Collectors.toList());
    }

    public void reset() {
        GlassFishLogRecord record;
        while ((record = this.buffer.poll()) != null) {
        }
    }
}

