/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.net.ssl.SSLContext;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.security.auth.Subject;
import org.glassfish.admin.mbeanserver.BootAMXListener;
import org.glassfish.admin.mbeanserver.ConnectorStarter;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.admin.mbeanserver.ssl.JMXMasterPasswordImpl;
import org.glassfish.admin.mbeanserver.ssl.SSLClientConfigurator;
import org.glassfish.admin.mbeanserver.ssl.SSLParams;
import org.glassfish.admin.mbeanserver.ssl.SecureRMIServerSocketFactory;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.main.jdke.props.SystemProperties;

final class RMIConnectorStarter
extends ConnectorStarter {
    public static final String RMI_HOSTNAME_PROP = "java.rmi.server.hostname";
    private final Registry mRegistry;
    private final boolean mBindToSingleIP;
    private volatile MyRMIJRMPServerImpl mMyServer;
    private final MyRMIServerSocketFactory mServerSocketFactory;
    private final SecureRMIServerSocketFactory sslServerSocketFactory;
    private final SslRMIClientSocketFactory sslCsf;
    private String masterPassword = null;
    private static final Logger JMX_LOGGER = Util.JMX_LOGGER;
    @LogMessageInfo(level="INFO", message="Security enabled")
    private static final String SECURITY_ENABLED = "NCLS-JMX-00009";
    @LogMessageInfo(level="INFO", message="Binding RMI port to single IP address = {0}, port {1}")
    private static final String BINDING_TO_SINGLE_ADDR = "NCLS-JMX-00026";
    @LogMessageInfo(level="SEVERE", message="Error stopping RMIConnector", action="unknown", cause="unknown")
    private static final String ERROR_STOPPING = "NCLS-JMX-00011";
    @LogMessageInfo(level="INFO", message="MyRMIJRMPServerImpl: exported on address {0}")
    private static final String EXPORTED = "NCLS-JMX-00012";
    @LogMessageInfo(message="MyRMIJRMPServerImpl: makeClient on address = {0}")
    private static final String MAKE_CLIENT = "NCLS-JMX-00013";

    public RMIConnectorStarter(MBeanServer mbeanServer, String address, int port, String protocol, boolean securityEnabled, ServiceLocator habitat, BootAMXListener bootListener, Ssl sslConfig) throws UnknownHostException {
        super(mbeanServer, address, port, securityEnabled, habitat, bootListener);
        this.masterPassword = new String(((JMXMasterPasswordImpl)habitat.getService(JMXMasterPasswordImpl.class, new Annotation[0])).getMasterPassword());
        if (!"rmi_jrmp".equals(protocol)) {
            throw new IllegalArgumentException("JMXConnectorServer not yet supporting protocol: " + protocol);
        }
        boolean ENABLED = true;
        this.mBindToSingleIP = !address.equals("0.0.0.0") && !address.equals("");
        InetAddress inetAddr = RMIConnectorStarter.getAddress(address);
        if (this.mBindToSingleIP) {
            if (this.isSecurityEnabled()) {
                JMX_LOGGER.info(SECURITY_ENABLED);
                this.sslServerSocketFactory = new SecureRMIServerSocketFactory(habitat, sslConfig, inetAddr);
                this.sslCsf = this.getClientSocketFactory(sslConfig);
                this.mServerSocketFactory = null;
            } else {
                this.mServerSocketFactory = new MyRMIServerSocketFactory(inetAddr);
                this.sslServerSocketFactory = null;
                this.sslCsf = null;
            }
        } else {
            this.mServerSocketFactory = null;
            if (this.isSecurityEnabled()) {
                this.sslServerSocketFactory = new SecureRMIServerSocketFactory(habitat, sslConfig, RMIConnectorStarter.getAddress(address));
                this.sslCsf = this.getClientSocketFactory(sslConfig);
            } else {
                this.sslServerSocketFactory = null;
                this.sslCsf = null;
            }
        }
        this.mRegistry = this.startRegistry(address, this.mPort);
    }

    private static InetAddress getAddress(String addrSpec) throws UnknownHostException {
        String actual = addrSpec;
        if (addrSpec.equals("localhost")) {
            actual = "127.0.0.1";
        }
        return InetAddress.getByName(actual);
    }

    static String setupRMIHostname(String host) {
        return SystemProperties.setProperty((String)RMI_HOSTNAME_PROP, (String)host, (boolean)true);
    }

    private static void restoreRMIHostname(String saved, String expectedValue) {
        if (saved == null) {
            SystemProperties.setProperty((String)RMI_HOSTNAME_PROP, null, (boolean)true);
        } else {
            String temp = SystemProperties.setProperty((String)RMI_HOSTNAME_PROP, (String)saved, (boolean)true);
            if (!temp.equals(expectedValue)) {
                throw new IllegalStateException("Something changed java.rmi.server.hostname to " + temp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Registry startRegistry(String addr, int port) {
        Registry registry = null;
        if (this.mBindToSingleIP) {
            String saved = RMIConnectorStarter.setupRMIHostname(addr);
            try {
                JMX_LOGGER.log(Level.INFO, BINDING_TO_SINGLE_ADDR, new Object[]{System.getProperty(RMI_HOSTNAME_PROP), port});
                registry = this._startRegistry(port);
            }
            finally {
                RMIConnectorStarter.restoreRMIHostname(saved, addr);
            }
        } else {
            Util.getLogger().log(Level.FINE, "Binding RMI port to *:{0}", port);
            registry = this._startRegistry(port);
        }
        return registry;
    }

    private Registry _startRegistry(int port) {
        SystemProperties.setProperty((String)"java.rmi.server.randomIDs", (String)"true", (boolean)true);
        try {
            if (this.isSecurityEnabled()) {
                return LocateRegistry.createRegistry(port, this.sslCsf, this.sslServerSocketFactory);
            }
            return LocateRegistry.createRegistry(port, null, this.mServerSocketFactory);
        }
        catch (Exception e) {
            throw new RuntimeException("Port " + port + " is not available for the internal rmi registry. This means that a call was made with the same port, without closing earlier registry instance. This has to do with the system jmx connector configuration in admin-service element of the configuration associated with this instance");
        }
    }

    @Override
    public JMXConnectorServer start() throws MalformedURLException, IOException, UnknownHostException {
        String name = "jmxrmi";
        String hostname = this.hostname();
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.jndi.rebind", "true");
        env.put("jmx.remote.rmi.server.credentials.filter.pattern", String.class.getName() + ";!*");
        env.put("jmx.remote.rmi.client.socket.factory", this.sslCsf);
        env.put("jmx.remote.rmi.server.socket.factory", this.sslServerSocketFactory);
        env.put("com.sun.jndi.rmi.factory.socket", this.sslCsf);
        JMXAuthenticator authenticator = this.getAccessController();
        if (authenticator != null) {
            env.put("jmx.remote.authenticator", authenticator);
        }
        String jmxHostPort = hostname + ":" + this.mPort;
        String registryHostPort = hostname + ":" + this.mPort;
        String urlStr = "service:jmx:rmi://" + jmxHostPort + "/jndi/rmi://" + registryHostPort + "/jmxrmi";
        this.mJMXServiceURL = new JMXServiceURL(urlStr);
        if (this.mBindToSingleIP) {
            RMIServerSocketFactory rmiSSF = this.isSecurityEnabled() ? this.sslServerSocketFactory : this.mServerSocketFactory;
            this.mMyServer = new MyRMIJRMPServerImpl(this.mPort, env, rmiSSF, hostname);
            this.mConnectorServer = new RMIConnectorServer(this.mJMXServiceURL, env, this.mMyServer, this.mMBeanServer);
        } else {
            this.mConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.mJMXServiceURL, env, this.mMBeanServer);
        }
        if (this.mBootListener != null) {
            this.mConnectorServer.addNotificationListener(this.mBootListener, null, this.mJMXServiceURL.toString());
        }
        this.mConnectorServer.start();
        return this.mConnectorServer;
    }

    public void stopAndUnexport() {
        super.stop();
        try {
            if (this.mBindToSingleIP) {
                this.mRegistry.unbind(this.mHostName);
            }
            UnicastRemoteObject.unexportObject(this.mRegistry, true);
        }
        catch (RemoteException ex) {
            Util.getLogger().log(Level.SEVERE, ERROR_STOPPING, ex);
        }
        catch (NotBoundException ex) {
            Util.getLogger().log(Level.SEVERE, ERROR_STOPPING, ex);
        }
    }

    private SslRMIClientSocketFactory getClientSocketFactory(Ssl sslConfig) {
        String enabledCipherSuites;
        SSLParams sslParams = this.convertToSSLParams(sslConfig);
        SSLClientConfigurator sslCC = SSLClientConfigurator.getInstance();
        sslCC.setSSLParams(sslParams);
        SSLContext sslContext = sslCC.configure(sslParams);
        Security.setProperty("ssl.SocketFactory.provider", sslContext.getClass().getName());
        String enabledProtocols = sslCC.getEnabledProtocolsAsString();
        if (enabledProtocols != null) {
            SystemProperties.setProperty((String)"javax.rmi.ssl.client.enabledProtocols", (String)enabledProtocols, (boolean)true);
        }
        if ((enabledCipherSuites = sslCC.getEnabledCipherSuitesAsString()) != null) {
            SystemProperties.setProperty((String)"javax.rmi.ssl.client.enabledCipherSuites", (String)enabledCipherSuites, (boolean)true);
        }
        SystemProperties.setProperty((String)GlassFishVariable.KEYSTORE_PASSWORD.getSystemPropertyName(), (String)(sslParams.getKeyStorePassword() == null ? "changeit" : sslParams.getKeyStorePassword()), (boolean)true);
        SystemProperties.setProperty((String)GlassFishVariable.TRUSTSTORE_PASSWORD.getSystemPropertyName(), (String)(sslParams.getTrustStorePassword() == null ? "changeit" : sslParams.getTrustStorePassword()), (boolean)true);
        return new SslRMIClientSocketFactory();
    }

    private SSLParams convertToSSLParams(Ssl sslConfig) {
        String trustStoreType = sslConfig.getTrustStoreType() == null ? System.getProperty(GlassFishVariable.TRUSTSTORE_TYPE.getSystemPropertyName(), "PKCS12") : sslConfig.getTrustStoreType();
        String trustStorePwd = sslConfig.getTrustStorePassword() == null ? this.masterPassword : sslConfig.getTrustStorePassword();
        File trustStore = sslConfig.getTrustStore() == null ? new File(System.getProperty(GlassFishVariable.TRUSTSTORE_FILE.getSystemPropertyName())) : new File(sslConfig.getTrustStore());
        String keyStoreType = sslConfig.getTrustStoreType() == null ? System.getProperty(GlassFishVariable.KEYSTORE_TYPE.getSystemPropertyName(), "PKCS12") : sslConfig.getKeyStoreType();
        String keyStorePwd = sslConfig.getTrustStorePassword() == null ? this.masterPassword : sslConfig.getKeyStorePassword();
        File keyStore = sslConfig.getTrustStore() == null ? new File(System.getProperty(GlassFishVariable.KEYSTORE_FILE.getSystemPropertyName())) : new File(sslConfig.getKeyStore());
        SSLParams sslParams = new SSLParams(trustStore, trustStorePwd, trustStoreType);
        sslParams.setTrustAlgorithm(sslConfig.getTrustAlgorithm());
        sslParams.setCertNickname(sslConfig.getCertNickname());
        sslParams.setCrlFile(sslConfig.getCrlFile());
        sslParams.setClientAuthEnabled(sslConfig.getClientAuthEnabled());
        sslParams.setClientAuth(sslConfig.getClientAuth());
        sslParams.setKeyAlgorithm(sslConfig.getKeyAlgorithm());
        sslParams.setKeyStore(keyStore.getAbsolutePath());
        sslParams.setKeyStorePassword(keyStorePwd);
        sslParams.setKeyStoreType(keyStoreType);
        sslParams.setSsl2Ciphers(sslConfig.getSsl2Ciphers());
        sslParams.setSsl2Enabled(sslConfig.getSsl2Enabled());
        sslParams.setSsl3Enabled(sslConfig.getSsl3Enabled());
        sslParams.setSsl3TlsCiphers(sslConfig.getSsl3TlsCiphers());
        sslParams.setTlsEnabled(sslConfig.getTlsEnabled());
        sslParams.setTlsRollbackEnabled(sslConfig.getTlsRollbackEnabled());
        return sslParams;
    }

    public static final class MyRMIServerSocketFactory
    extends RMISocketFactory {
        private final InetAddress mAddress;

        public MyRMIServerSocketFactory(InetAddress addr) {
            this.mAddress = addr;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            int backlog = 5;
            ServerSocket s = new ServerSocket(port, 5, this.mAddress);
            return s;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            Socket s = new Socket(host, port);
            return s;
        }
    }

    private static final class MyRMIJRMPServerImpl
    extends RMIJRMPServerImpl {
        private final String mBindToAddr;

        public MyRMIJRMPServerImpl(int port, Map<String, ?> env, RMIServerSocketFactory serverSocketFactory, String bindToAddr) throws IOException {
            super(port, (RMIClientSocketFactory)env.get("jmx.remote.rmi.client.socket.factory"), serverSocketFactory, env);
            this.mBindToAddr = bindToAddr;
        }

        protected synchronized void export(String host) throws IOException {
            String saved = RMIConnectorStarter.setupRMIHostname(this.mBindToAddr);
            try {
                super.export();
                JMX_LOGGER.log(Level.INFO, RMIConnectorStarter.EXPORTED, this.mBindToAddr);
            }
            finally {
                RMIConnectorStarter.restoreRMIHostname(saved, this.mBindToAddr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized RMIConnection makeClient(String connectionId, Subject subject) throws IOException {
            String saved = RMIConnectorStarter.setupRMIHostname(this.mBindToAddr);
            try {
                Util.getLogger().log(Level.INFO, RMIConnectorStarter.MAKE_CLIENT, System.getProperty(RMIConnectorStarter.RMI_HOSTNAME_PROP));
                RMIConnection rMIConnection = super.makeClient(connectionId, subject);
                return rMIConnection;
            }
            finally {
                RMIConnectorStarter.restoreRMIHostname(saved, this.mBindToAddr);
            }
        }
    }
}

