/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.transaction;

import jakarta.persistence.EntityTransaction;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.TransactionRequiredException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.Transaction;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapperImpl;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.transaction.AbstractTransactionController;
import org.eclipse.persistence.transaction.TransactionException;

public class JTATransactionWrapper
extends TransactionWrapperImpl
implements TransactionWrapper {
    protected AbstractTransactionController txnController;
    private boolean isJoined = false;

    public JTATransactionWrapper(EntityManagerImpl entityManager) {
        super(entityManager);
        this.txnController = (AbstractTransactionController)entityManager.getDatabaseSession().getExternalTransactionController();
    }

    @Override
    public Object checkForTransaction(boolean validateExistence) {
        Object transaction = this.txnController.getTransaction();
        if (validateExistence && transaction == null) {
            this.throwCheckTransactionFailedException();
        }
        return transaction;
    }

    @Override
    public void clear() {
        this.localUOW.release();
        this.localUOW = null;
    }

    @Override
    public EntityTransaction getTransaction() {
        throw new IllegalStateException(TransactionException.entityTransactionWithJTANotAllowed().getMessage());
    }

    @Override
    public void setRollbackOnlyInternal() {
        if (this.txnController.getTransaction() != null) {
            this.txnController.markTransactionForRollback();
        }
    }

    protected void throwUserTransactionException() {
        throw TransactionException.entityTransactionWithJTANotAllowed();
    }

    protected void throwCheckTransactionFailedException() {
        throw new TransactionRequiredException(TransactionException.externalTransactionNotActive().getMessage());
    }

    @Override
    public boolean isJoinedToTransaction(UnitOfWorkImpl uow) {
        if (this.entityManager.hasActivePersistenceContext()) {
            return uow.getParent().hasExternalTransactionController() && uow.isSynchronized();
        }
        return this.isJoined;
    }

    @Override
    public void registerIfRequired(UnitOfWorkImpl uow) {
        if (this.entityManager.hasActivePersistenceContext()) {
            uow.registerWithTransactionIfRequired();
        } else if (!this.isJoined) {
            Object txn = this.checkForTransaction(true);
            try {
                ((Transaction)txn).registerSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int status) {
                        JTATransactionWrapper.this.isJoined = false;
                    }
                });
            }
            catch (Exception e) {
                throw new PersistenceException(TransactionException.errorBindingToExternalTransaction((Exception)e).getMessage(), (Throwable)e);
            }
            this.isJoined = true;
        }
    }
}

