/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.jsf;

import jakarta.faces.application.ViewHandler;
import jakarta.faces.application.ViewHandlerWrapper;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.jboss.weld.Container;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.module.jsf.FacesUrlTransformer;

public class ConversationAwareViewHandler
extends ViewHandlerWrapper {
    private final ViewHandler delegate;
    private volatile ConversationContext conversationContext;
    private static final ThreadLocal<Source> source = new ThreadLocal();
    private String contextId;

    public ConversationAwareViewHandler(ViewHandler delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConversationContext getConversationContext(String id) {
        if (this.conversationContext == null) {
            ConversationAwareViewHandler conversationAwareViewHandler = this;
            synchronized (conversationAwareViewHandler) {
                if (this.conversationContext == null) {
                    if (!Container.available(id)) {
                        return null;
                    }
                    Container container = Container.instance(id);
                    this.conversationContext = (ConversationContext)container.deploymentManager().instance().select(HttpConversationContext.class, new Annotation[0]).get();
                }
            }
        }
        return this.conversationContext;
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        if (this.contextId == null) {
            this.contextId = facesContext.getAttributes().containsKey("WELD_CONTEXT_ID_KEY") ? (String)facesContext.getAttributes().get("WELD_CONTEXT_ID_KEY") : "STATIC_INSTANCE";
        }
        String actionUrl = super.getActionURL(facesContext, viewId);
        ConversationContext ctx = this.getConversationContext(this.contextId);
        if (ctx != null && ctx.isActive() && !this.getSource().equals((Object)Source.BOOKMARKABLE) && !ctx.getCurrentConversation().isTransient()) {
            return new FacesUrlTransformer(actionUrl, facesContext).appendConversationIdIfNecessary(this.getConversationContext(this.contextId).getParameterName(), ctx.getCurrentConversation().getId()).getUrl();
        }
        return actionUrl;
    }

    private Source getSource() {
        if (source.get() == null) {
            return Source.ACTION;
        }
        return source.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        try {
            source.set(Source.BOOKMARKABLE);
            String string = super.getBookmarkableURL(context, viewId, parameters, includeViewParams);
            return string;
        }
        finally {
            source.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        try {
            source.set(Source.REDIRECT);
            String string = super.getRedirectURL(context, viewId, parameters, includeViewParams);
            return string;
        }
        finally {
            source.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceURL(FacesContext context, String path) {
        try {
            source.set(Source.RESOURCE);
            String string = super.getResourceURL(context, path);
            return string;
        }
        finally {
            source.remove();
        }
    }

    public ViewHandler getWrapped() {
        return this.delegate;
    }

    private static enum Source {
        ACTION,
        BOOKMARKABLE,
        REDIRECT,
        RESOURCE;

    }
}

