/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer.cfg;

import com.sun.enterprise.deployment.types.ConcurrencyContextType;
import java.io.Serializable;
import java.util.Set;
import org.glassfish.concurrent.config.ManagedThreadFactory;
import org.glassfish.concurrent.runtime.deployer.cfg.CfgParser;
import org.glassfish.concurrent.runtime.deployer.cfg.ConcurrentServiceCfg;

public class ManagedThreadFactoryCfg
implements Serializable {
    private static final long serialVersionUID = -7772066566768020144L;
    private final ConcurrentServiceCfg serviceConfig;
    private final boolean useVirtualThreads;
    private final int threadPriority;

    public ManagedThreadFactoryCfg(ManagedThreadFactory config) {
        Set<ConcurrencyContextType> propagated = CfgParser.parseContextInfo(config.getContextInfo(), config.getContextInfoEnabled());
        this.serviceConfig = new ConcurrentServiceCfg(config.getJndiName(), propagated, config.getContext());
        this.useVirtualThreads = Boolean.parseBoolean(config.getUseVirtualThreads());
        this.threadPriority = CfgParser.parseInt(config.getThreadPriority(), 5);
    }

    public ConcurrentServiceCfg getServiceConfig() {
        return this.serviceConfig;
    }

    public boolean getUseVirtualThreads() {
        return this.useVirtualThreads;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }
}

