/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.wadl;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.SchemaOutputResolver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.composite.LegacyCompositeResource;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;

@Path(value="/schema.xsd")
@Service
public class RestModelSchemaResource
extends LegacyCompositeResource {
    private static final Set<Class<?>> WRAPPER_TYPES = new HashSet(){
        {
            this.add(Boolean.class);
            this.add(Character.class);
            this.add(Byte.class);
            this.add(Short.class);
            this.add(Integer.class);
            this.add(Long.class);
            this.add(Float.class);
            this.add(Double.class);
            this.add(Void.class);
        }
    };

    @GET
    @Path(value="old")
    public String getSchema() throws JAXBException, IOException {
        TreeSet classes = new TreeSet(new Comparator<Class<?>>(this){

            @Override
            public int compare(Class<?> t, Class<?> t1) {
                return t.getName().compareTo(t1.getName());
            }
        });
        for (String c : this.locateRestModels()) {
            try {
                Class<?> modelClass = this.loadClass(c);
                if (modelClass.getSimpleName().charAt(0) >= 'C') continue;
                classes.add(this.getCompositeUtil().getModel(modelClass).getClass());
            }
            catch (ClassNotFoundException ex) {
                RestLogging.restLogger.log(Level.WARNING, null, ex);
            }
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])((Class[])classes.toArray(Class[]::new)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        jc.generateSchema((SchemaOutputResolver)new MySchemaOutputResolver(baos));
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    @GET
    @Path(value="test1")
    public String getSchema1() throws JAXBException, IOException {
        TreeSet classes = new TreeSet(new Comparator<Class<?>>(this){

            @Override
            public int compare(Class<?> t, Class<?> t1) {
                return t.getName().compareTo(t1.getName());
            }
        });
        try {
            Class<?> modelClass = this.loadClass("org.glassfish.admin.rest.resources.composite.Job");
            classes.add(this.getCompositeUtil().getModel(modelClass).getClass());
            modelClass = this.loadClass("org.glassfish.admin.rest.resources.composite.Dummy");
            classes.add(this.getCompositeUtil().getModel(modelClass).getClass());
        }
        catch (ClassNotFoundException ex) {
            RestLogging.restLogger.log(Level.WARNING, null, ex);
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])((Class[])classes.toArray(Class[]::new)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        jc.generateSchema((SchemaOutputResolver)new MySchemaOutputResolver(baos));
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    @GET
    public String getSchemaManually() {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<xs:schema version=\"1.0\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n");
        StringBuilder complexTypes = new StringBuilder();
        this.addElement(sb, "object");
        this.processClass(complexTypes, Object.class, "object");
        for (String c : this.locateRestModels()) {
            try {
                Class<?> modelClass = this.getCompositeUtil().getModel(this.loadClass(c)).getClass();
                String simpleName = modelClass.getSimpleName().toLowerCase(Locale.getDefault());
                if (simpleName.endsWith("impl")) {
                    simpleName = simpleName.substring(0, simpleName.length() - 4);
                }
                this.addElement(sb, simpleName);
                this.processClass(complexTypes, modelClass, simpleName);
            }
            catch (ClassNotFoundException ex) {
                RestLogging.restLogger.log(Level.WARNING, null, ex);
            }
        }
        sb.append((CharSequence)complexTypes);
        return sb.append("</xs:schema>\n").toString();
    }

    protected void processClass(StringBuilder sb, Class<?> c, String simpleName) {
        sb.append("\t<xs:complexType name=\"").append(simpleName).append("\">\n\t\t<xs:sequence>\n");
        for (Class<?> i : c.getInterfaces()) {
            for (Method m : i.getDeclaredMethods()) {
                Object name = m.getName();
                if (!((String)name).startsWith("get") || "getClass".equals(name)) continue;
                name = ((String)name).substring(3, 4).toLowerCase(Locale.getDefault()) + ((String)name).substring(4);
                Class returnType = m.getReturnType();
                sb.append("\t\t\t<xs:element name=\"").append((String)name).append("\" ");
                if (returnType.isPrimitive()) {
                    sb.append(this.getType(returnType));
                } else if (WRAPPER_TYPES.contains(returnType) || String.class.equals(returnType) || Object.class.equals(returnType)) {
                    sb.append(this.getType(returnType)).append(" minOccurs=\"0\"");
                } else if (List.class.equals(returnType)) {
                    ParameterizedType rt = (ParameterizedType)m.getGenericReturnType();
                    returnType = (Class)rt.getActualTypeArguments()[0];
                    sb.append(this.getType(returnType)).append(" nillable=\"true\" minOccurs=\"0\" maxOccurs=\"unbounded\"");
                }
                sb.append("/>\n");
            }
        }
        sb.append("\t\t</xs:sequence>\n\t</xs:complexType>\n");
    }

    private String getType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return "type=\"xs:" + clazz.getSimpleName() + "\"";
        }
        if (WRAPPER_TYPES.contains(clazz) || String.class.equals(clazz)) {
            return "type=\"xs:" + clazz.getSimpleName().toLowerCase(Locale.getDefault()) + "\"";
        }
        return "type=\"" + clazz.getSimpleName().toLowerCase(Locale.getDefault()) + "\"";
    }

    private Set<String> locateRestModels() {
        HashSet<String> classes = new HashSet<String>();
        List widgetDescriptors = Globals.getDefaultBaseServiceLocator().getDescriptors((Filter)BuilderHelper.createContractFilter((String)RestModel.class.getName()));
        for (ActiveDescriptor ad : widgetDescriptors) {
            classes.add(ad.getImplementation());
        }
        return classes;
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            return this.getClass().getClassLoader().loadClass(className);
        }
    }

    private void addElement(StringBuilder sb, String simpleName) {
        sb.append("\t<xs:element name=\"").append(simpleName).append("\" type=\"").append(simpleName).append("\"/>\n");
    }

    private static class MySchemaOutputResolver
    extends SchemaOutputResolver {
        ByteArrayOutputStream baos;

        private MySchemaOutputResolver(ByteArrayOutputStream baos) {
            this.baos = baos;
        }

        public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
            StreamResult r = new StreamResult("argh");
            r.setOutputStream(this.baos);
            return r;
        }
    }
}

