/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.common.client.handler;

import ee.jakarta.tck.pages.common.client.handler.Handler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Header;

public class LocationHandler
implements Handler {
    private static final Logger LOGGER = Logger.getLogger(LocationHandler.class.getName());
    private static Handler handler = new LocationHandler();

    private LocationHandler() {
    }

    public static Handler getInstance() {
        return handler;
    }

    @Override
    public boolean invoke(Header configuredHeader, Header responseHeader) {
        boolean pass = true;
        try {
            LOGGER.finer("LocationHandler invoked.");
            URL configURL = new URL(configuredHeader.getValue());
            URL responseURL = new URL(responseHeader.getValue());
            if (!configURL.getProtocol().equals(responseURL.getProtocol())) {
                pass = false;
                LOGGER.severe("Mismatch between protocols:");
                LOGGER.severe("Configured value: " + configURL.getProtocol());
                LOGGER.severe("Response value: " + responseURL.getProtocol());
            }
            if (!configURL.getPath().equals(responseURL.getPath())) {
                pass = false;
                LOGGER.severe("Mismatch between paths:");
                LOGGER.severe("Configured value: " + configURL.getPath());
                LOGGER.severe("Response value: " + responseURL.getPath());
            }
            if (configURL.getQuery() == null) {
                if (responseURL.getQuery() != null) {
                    pass = false;
                    LOGGER.severe("Mismatch between querys:");
                    LOGGER.severe("Configured value is null");
                    LOGGER.severe("Response value is non-null");
                }
            } else if (!configURL.getQuery().equals(responseURL.getQuery())) {
                pass = false;
                LOGGER.severe("Mismatch between querys:");
                LOGGER.severe("Configured value: " + configURL.getQuery());
                LOGGER.severe("Response value: " + responseURL.getQuery());
            }
        }
        catch (MalformedURLException mue) {
            pass = false;
            LOGGER.log(Level.SEVERE, "MalformedURLException", mue);
        }
        return pass;
    }
}

