/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.signaturetest;

import com.sun.ts.tests.signaturetest.SigTest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.junit.jupiter.api.Test;

public class WebSocketSigTestIT
extends SigTest {
    private static final long serialVersionUID = -5264596249711347960L;
    public static final String EJB_VEHICLE = "ejb";
    public static final String SERVLET_VEHICLE = "servlet";
    public static final String JSP_VEHICLE = "jsp";
    public static final String APP_CLIENT_VEHICLE = "appclient";
    public static final String NO_VEHICLE = "standalone";
    private static final System.Logger logger = System.getLogger(WebSocketSigTestIT.class.getName());
    private static final String[] DEFAULT_PKGS = new String[]{"jakarta.websocket", "jakarta.websocket.server"};
    private static final String[] EJB_SERVLET_JSP_PKGS = new String[0];
    private static final String[] SERVLET_JSP_PKGS = new String[0];
    private static final String[] NO_CONTAINER_PKGS = new String[]{"jakarta.websocket", "jakarta.websocket.server"};

    protected String[] getPackages() {
        return DEFAULT_PKGS;
    }

    private static void addDefaultPkgs(List<String> sigArgsList) {
        for (int i = 0; i < DEFAULT_PKGS.length; ++i) {
            sigArgsList.add(DEFAULT_PKGS[i]);
        }
    }

    private static void addEjbServletJspPkgs(List<String> sigArgsList) {
        for (int i = 0; i < EJB_SERVLET_JSP_PKGS.length; ++i) {
            sigArgsList.add(EJB_SERVLET_JSP_PKGS[i]);
        }
    }

    private static void addServletJspPkgs(List<String> sigArgsList) {
        for (int i = 0; i < SERVLET_JSP_PKGS.length; ++i) {
            sigArgsList.add(SERVLET_JSP_PKGS[i]);
        }
    }

    private static void addNoContainerPkgs(List<String> sigArgsList) {
        for (int i = 0; i < NO_CONTAINER_PKGS.length; ++i) {
            sigArgsList.add(NO_CONTAINER_PKGS[i]);
        }
    }

    public WebSocketSigTestIT() {
        this.setup(new String[0], System.getProperties());
    }

    protected String[] getPackages(String vehicleName) {
        LinkedList<String> packages = new LinkedList<String>();
        if (vehicleName.equals(NO_VEHICLE)) {
            WebSocketSigTestIT.addNoContainerPkgs(packages);
        } else {
            WebSocketSigTestIT.addDefaultPkgs(packages);
            if (vehicleName.equals(EJB_VEHICLE) || vehicleName.equals(SERVLET_VEHICLE) || vehicleName.equals(JSP_VEHICLE)) {
                WebSocketSigTestIT.addEjbServletJspPkgs(packages);
            }
            if (vehicleName.equals(SERVLET_VEHICLE) || vehicleName.equals(JSP_VEHICLE)) {
                WebSocketSigTestIT.addServletJspPkgs(packages);
            }
        }
        return packages.toArray(new String[packages.size()]);
    }

    @Test
    public void signatureTest() throws Exception {
        logger.log(System.Logger.Level.INFO, "$$$ SigTestIT.signatureTest() called");
        String mapFile = null;
        String packageFile = null;
        Object repositoryDir = null;
        Properties mapFileAsProps = null;
        String[] packages = this.getPackages();
        String apiPackage = "jakarta.websocket";
        try {
            InputStream inStreamMapfile = WebSocketSigTestIT.class.getClassLoader().getResourceAsStream("com/sun/ts/tests/websocket/signaturetest/sig-test.map");
            File mFile = this.writeStreamToTempFile(inStreamMapfile, "sig-test", ".map");
            mapFile = mFile.getCanonicalPath();
            logger.log(System.Logger.Level.INFO, "mapFile location is :" + mapFile);
            InputStream inStreamPackageFile = WebSocketSigTestIT.class.getClassLoader().getResourceAsStream("com/sun/ts/tests/websocket/signaturetest/sig-test-pkg-list.txt");
            File pFile = this.writeStreamToTempFile(inStreamPackageFile, "sig-test-pkg-list", ".txt");
            packageFile = pFile.getCanonicalPath();
            logger.log(System.Logger.Level.INFO, "packageFile location is :" + packageFile);
            mapFileAsProps = this.getSigTestDriver().loadMapFile(mapFile);
            String packageVersion = mapFileAsProps.getProperty(apiPackage);
            logger.log(System.Logger.Level.INFO, "Package version from mapfile :" + packageVersion);
            InputStream inStreamSigFile = WebSocketSigTestIT.class.getClassLoader().getResourceAsStream("com/sun/ts/tests/websocket/signaturetest/jakarta.websocket.sig_" + packageVersion);
            File sigFile = this.writeStreamToSigFile(inStreamSigFile, apiPackage, packageVersion);
            logger.log(System.Logger.Level.INFO, "signature File location is :" + sigFile.getCanonicalPath());
        }
        catch (IOException ex) {
            logger.log(System.Logger.Level.ERROR, "Exception while creating temp files :" + String.valueOf(ex));
        }
        super.signatureTest(mapFile, packageFile, mapFileAsProps, packages);
    }
}

