/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks.boundedresponse;

import com.github.javabdd.BDD;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.bdd.settings.CifBddSettings;
import org.eclipse.escet.cif.bdd.settings.EdgeGranularity;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeApplyDirection;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeKind;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.controllercheck.ControllerCheckerSettings;
import org.eclipse.escet.cif.controllercheck.checks.ControllerCheckerBddBasedCheck;
import org.eclipse.escet.cif.controllercheck.checks.boundedresponse.Bound;
import org.eclipse.escet.cif.controllercheck.checks.boundedresponse.BoundedResponseCheckConclusion;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class BoundedResponseCheck
extends ControllerCheckerBddBasedCheck<BoundedResponseCheckConclusion> {
    public static final String PROPERTY_NAME = "bounded response";
    private static final boolean VERBOSE_DEBUG_OUTPUT = false;
    private final int maxPrintedCycleStatesCount;

    public BoundedResponseCheck(int maxPrintedCycleStatesCount) {
        this.maxPrintedCycleStatesCount = maxPrintedCycleStatesCount;
    }

    @Override
    public String getPropertyName() {
        return PROPERTY_NAME;
    }

    @Override
    protected CifBddSettings createCifBddSettings(ControllerCheckerSettings checkerSettings) {
        CifBddSettings cifBddSettings = super.createCifBddSettings(checkerSettings);
        cifBddSettings.setEdgeGranularity(EdgeGranularity.PER_EDGE);
        cifBddSettings.setEdgeOrderForward("sorted");
        cifBddSettings.setAdhereToExecScheme(true);
        return cifBddSettings;
    }

    @Override
    public BoundedResponseCheckConclusion performCheck(CifBddSpec cifBddSpec) {
        Termination termination = cifBddSpec.settings.getTermination();
        DebugNormalOutput dbg = cifBddSpec.settings.getDebugOutput();
        if (cifBddSpec.initial.isZero()) {
            dbg.line("No initial states.");
            return new BoundedResponseCheckConclusion(new Bound(false, true, 0, null, null), new Bound(false, true, 0, null, null), this.maxPrintedCycleStatesCount);
        }
        List orderedEdges = cifBddSpec.orderedEdgesForward;
        List<CifBddEdge> inputEdges = orderedEdges.stream().filter(edge -> edge.getEdgeKind() == CifBddEdgeKind.INPUT_VARIABLE).toList();
        List<CifBddEdge> uncontrollableEdges = orderedEdges.stream().filter(edge -> edge.getEdgeKind() == CifBddEdgeKind.UNCONTROLLABLE).toList();
        List<CifBddEdge> controllableEdges = orderedEdges.stream().filter(edge -> edge.getEdgeKind() == CifBddEdgeKind.CONTROLLABLE).toList();
        Map edgesPerInputEvent = inputEdges.stream().collect(Collectors.groupingBy(edge -> edge.event, Maps::map, Lists.toList()));
        Map edgesPerUnctrlEvent = uncontrollableEdges.stream().collect(Collectors.groupingBy(edge -> edge.event, Maps::map, Lists.toList()));
        Map edgesPerCtrlEvent = controllableEdges.stream().collect(Collectors.groupingBy(edge -> edge.event, Maps::map, Lists.toList()));
        dbg.line("Computing states we can be in at the start of uncontrollable and controllable event loops:");
        dbg.inc();
        Pair<BDD, BDD> preStates = this.computeLoopsStartStates(cifBddSpec, edgesPerInputEvent, edgesPerUnctrlEvent, edgesPerCtrlEvent);
        dbg.dec();
        termination.throwIfRequested();
        BDD preUnctrlStates = (BDD)preStates.left;
        BDD preCtrlStates = (BDD)preStates.right;
        dbg.line();
        dbg.line("Computing bound for uncontrollable events:");
        dbg.inc();
        Bound uncontrollablesBound = this.computeLoopBound(cifBddSpec, preUnctrlStates, edgesPerUnctrlEvent, "uncontrollable");
        termination.throwIfRequested();
        preUnctrlStates.free();
        dbg.line();
        dbg.line("Bound: %s.", new Object[]{uncontrollablesBound.isBounded() ? Integer.valueOf(uncontrollablesBound.getBound()) : "n/a (cycle)"});
        dbg.dec();
        termination.throwIfRequested();
        dbg.line();
        dbg.line("Computing bound for controllable events:");
        dbg.inc();
        Bound controllablesBound = this.computeLoopBound(cifBddSpec, preCtrlStates, edgesPerCtrlEvent, "controllable");
        termination.throwIfRequested();
        preCtrlStates.free();
        dbg.line();
        dbg.line("Bound: %s.", new Object[]{controllablesBound.isBounded() ? Integer.valueOf(controllablesBound.getBound()) : "n/a (cycle)"});
        dbg.dec();
        termination.throwIfRequested();
        dbg.line();
        dbg.line("Bounded response check completed.");
        return new BoundedResponseCheckConclusion(uncontrollablesBound, controllablesBound, this.maxPrintedCycleStatesCount);
    }

    private Pair<BDD, BDD> computeLoopsStartStates(CifBddSpec cifBddSpec, Map<Event, List<CifBddEdge>> edgesPerInputEvent, Map<Event, List<CifBddEdge>> edgesPerUnctrlEvent, Map<Event, List<CifBddEdge>> edgesPerCtrlEvent) {
        boolean fixedPointReached;
        Termination termination = cifBddSpec.settings.getTermination();
        DebugNormalOutput dbg = cifBddSpec.settings.getDebugOutput();
        BDD startStatesInput = cifBddSpec.initial.id();
        BDD startStatesUnctrl = cifBddSpec.factory.zero();
        BDD startStatesCtrl = cifBddSpec.factory.zero();
        int round = 0;
        do {
            if (++round > 1) {
                dbg.line();
            }
            dbg.line("Round %,d:", new Object[]{round});
            dbg.inc();
            dbg.line("Pre input states: " + BddUtils.bddToStr((BDD)startStatesInput, (CifBddSpec)cifBddSpec));
            dbg.line("Pre uncontrollables states: " + BddUtils.bddToStr((BDD)startStatesUnctrl, (CifBddSpec)cifBddSpec));
            dbg.line("Pre controllables states: " + BddUtils.bddToStr((BDD)startStatesCtrl, (CifBddSpec)cifBddSpec));
            termination.throwIfRequested();
            BDD prevStartStatesInput = startStatesInput.id();
            BDD prevStartStatesUnctrl = startStatesUnctrl.id();
            BDD prevStartStatesCtrl = startStatesCtrl.id();
            termination.throwIfRequested();
            dbg.line();
            dbg.line("Applying event loop for input variable events:");
            dbg.inc();
            BDD endStatesInput = this.computeLoopEndStates(cifBddSpec, startStatesInput, edgesPerInputEvent, "input variable");
            dbg.dec();
            termination.throwIfRequested();
            BDD newStartStatesUnctrl = startStatesUnctrl.id().orWith(endStatesInput);
            if (!newStartStatesUnctrl.equals((Object)startStatesUnctrl)) {
                dbg.line();
                dbg.line("Pre uncontrollables states: %s -> %s", new Object[]{BddUtils.bddToStr((BDD)startStatesUnctrl, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newStartStatesUnctrl, (CifBddSpec)cifBddSpec)});
            }
            startStatesUnctrl.free();
            startStatesUnctrl = newStartStatesUnctrl;
            termination.throwIfRequested();
            dbg.line();
            dbg.line("Applying event loop for uncontrollable events:");
            dbg.inc();
            BDD endStatesUnctrl = this.computeLoopEndStates(cifBddSpec, startStatesUnctrl, edgesPerUnctrlEvent, "uncontrollable");
            dbg.dec();
            termination.throwIfRequested();
            BDD newStartStatesCtrl = startStatesCtrl.id().orWith(endStatesUnctrl);
            if (!newStartStatesCtrl.equals((Object)startStatesCtrl)) {
                dbg.line();
                dbg.line("Pre controllables states: %s -> %s", new Object[]{BddUtils.bddToStr((BDD)startStatesCtrl, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newStartStatesCtrl, (CifBddSpec)cifBddSpec)});
            }
            startStatesCtrl.free();
            startStatesCtrl = newStartStatesCtrl;
            termination.throwIfRequested();
            dbg.line();
            dbg.line("Applying event loop for controllable events:");
            dbg.inc();
            BDD endStatesCtrl = this.computeLoopEndStates(cifBddSpec, startStatesCtrl, edgesPerCtrlEvent, "controllable");
            dbg.dec();
            termination.throwIfRequested();
            BDD newStartStatesInput = startStatesInput.id().orWith(endStatesCtrl);
            if (!newStartStatesInput.equals((Object)startStatesInput)) {
                dbg.line();
                dbg.line("Pre input states: %s -> %s", new Object[]{BddUtils.bddToStr((BDD)startStatesInput, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)newStartStatesInput, (CifBddSpec)cifBddSpec)});
            }
            startStatesInput.free();
            startStatesInput = newStartStatesInput;
            termination.throwIfRequested();
            dbg.dec();
            fixedPointReached = prevStartStatesInput.equals((Object)startStatesInput) && prevStartStatesUnctrl.equals((Object)startStatesUnctrl) && prevStartStatesCtrl.equals((Object)startStatesCtrl);
            prevStartStatesInput.free();
            prevStartStatesUnctrl.free();
            prevStartStatesCtrl.free();
        } while (!fixedPointReached);
        startStatesInput.free();
        return Pair.pair((Object)startStatesUnctrl, (Object)startStatesCtrl);
    }

    private BDD computeLoopEndStates(CifBddSpec cifBddSpec, BDD startStates, Map<Event, List<CifBddEdge>> edgesPerEvent, String eventKindTxt) {
        boolean fixedPoint;
        Termination termination = cifBddSpec.settings.getTermination();
        DebugNormalOutput dbg = cifBddSpec.settings.getDebugOutput();
        if (edgesPerEvent.isEmpty()) {
            dbg.line("No %s events.", new Object[]{eventKindTxt});
            return startStates.id();
        }
        termination.throwIfRequested();
        BDD curStates = startStates.id();
        BDD allItersEndStates = cifBddSpec.factory.zero();
        int iteration = 0;
        do {
            if (++iteration > 1) {
                dbg.line();
            }
            dbg.line("Iteration %,d (states before iteration: %s):", new Object[]{iteration, BddUtils.bddToStr((BDD)curStates, (CifBddSpec)cifBddSpec)});
            dbg.inc();
            termination.throwIfRequested();
            BDD preIterAllItersEndStates = allItersEndStates.id();
            Pair<BDD, List<CifBddEdge>> iterResults = this.computeIterEndStates(cifBddSpec, curStates, edgesPerEvent);
            termination.throwIfRequested();
            curStates.free();
            curStates = (BDD)iterResults.left;
            allItersEndStates = allItersEndStates.orWith(curStates.id());
            dbg.line("All iterations end states: " + BddUtils.bddToStr((BDD)allItersEndStates, (CifBddSpec)cifBddSpec));
            termination.throwIfRequested();
            dbg.dec();
            fixedPoint = allItersEndStates.equalsBDD(preIterAllItersEndStates);
            preIterAllItersEndStates.free();
        } while (!fixedPoint);
        allItersEndStates.free();
        return curStates;
    }

    private Pair<BDD, List<CifBddEdge>> computeIterEndStates(CifBddSpec cifBddSpec, BDD startStates, Map<Event, List<CifBddEdge>> edgesPerEvent) {
        Termination termination = cifBddSpec.settings.getTermination();
        DebugNormalOutput dbg = cifBddSpec.settings.getDebugOutput();
        BDD curStates = startStates.id();
        List enabledEdges = Lists.list();
        boolean anyChange = false;
        for (Map.Entry<Event, List<CifBddEdge>> entry : edgesPerEvent.entrySet()) {
            Event event = entry.getKey();
            List<CifBddEdge> edges = entry.getValue();
            BDD preEventCurStates = curStates.id();
            BDD eventPreStates = curStates;
            BDD eventPostStates = cifBddSpec.factory.zero();
            for (CifBddEdge edge : edges) {
                boolean isEdgeEnabled;
                termination.throwIfRequested();
                BDD edgeEnabledStates = eventPreStates.and(edge.guard);
                termination.throwIfRequested();
                boolean bl = isEdgeEnabled = !edgeEnabledStates.isZero();
                if (isEdgeEnabled) {
                    enabledEdges.add(edge);
                }
                BDD restriction = null;
                BDD edgeTakenStates = edge.apply(edgeEnabledStates, CifBddEdgeApplyDirection.FORWARD, restriction);
                termination.throwIfRequested();
                BDD notGuard = edge.guard.not();
                BDD edgeNotTakenStates = eventPreStates.id().andWith(notGuard);
                termination.throwIfRequested();
                eventPostStates = eventPostStates.orWith(edgeTakenStates);
                termination.throwIfRequested();
                eventPreStates.free();
                eventPreStates = edgeNotTakenStates;
            }
            curStates = eventPreStates.orWith(eventPostStates);
            if (!curStates.equals((Object)preEventCurStates)) {
                dbg.line("Event %s: %s -> %s", new Object[]{CifTextUtils.getAbsName((PositionObject)event, (boolean)false), BddUtils.bddToStr((BDD)preEventCurStates, (CifBddSpec)cifBddSpec), BddUtils.bddToStr((BDD)curStates, (CifBddSpec)cifBddSpec)});
                anyChange = true;
            }
            preEventCurStates.free();
        }
        if (!anyChange) {
            dbg.line("%,d edge%s enabled. No state changes.", new Object[]{enabledEdges.size(), enabledEdges.size() == 1 ? "" : "s"});
        }
        return Pair.pair((Object)curStates, (Object)enabledEdges);
    }

    private Bound computeLoopBound(CifBddSpec cifBddSpec, BDD startStates, Map<Event, List<CifBddEdge>> edgesPerEvent, String eventKindTxt) {
        Bound result;
        boolean fixedPoint;
        Termination termination = cifBddSpec.settings.getTermination();
        DebugNormalOutput dbg = cifBddSpec.settings.getDebugOutput();
        if (edgesPerEvent.isEmpty()) {
            dbg.line("No %s events.", new Object[]{eventKindTxt});
            return new Bound(true, true, 0, null, null);
        }
        termination.throwIfRequested();
        BDD curStates = startStates.id();
        Integer iteration = 0;
        List enabledEdges = Collections.emptyList();
        do {
            if ((iteration = Integer.valueOf(iteration + 1)) < 0) {
                throw new UnsupportedException("Failed to compute bounded response, as the bound is too high.");
            }
            if (iteration > 1) {
                dbg.line();
            }
            dbg.line("Iteration %,d (states before iteration: %s):", new Object[]{iteration, BddUtils.bddToStr((BDD)curStates, (CifBddSpec)cifBddSpec)});
            dbg.inc();
            termination.throwIfRequested();
            BDD preIterCurStates = curStates.id();
            Pair<BDD, List<CifBddEdge>> iterResults = this.computeIterEndStates(cifBddSpec, curStates, edgesPerEvent);
            termination.throwIfRequested();
            curStates.free();
            curStates = (BDD)iterResults.left;
            enabledEdges = (List)iterResults.right;
            dbg.dec();
            fixedPoint = curStates.equalsBDD(preIterCurStates);
            preIterCurStates.free();
        } while (!fixedPoint);
        if (enabledEdges.isEmpty()) {
            result = new Bound(true, true, iteration - 1, null, null);
        } else {
            boolean complete;
            Assert.check((!enabledEdges.isEmpty() ? 1 : 0) != 0);
            List<String> enabledEdgesTexts = enabledEdges.stream().map(e -> e.toString("", true)).toList();
            int askedPrintedCycleStatesCount = this.maxPrintedCycleStatesCount + 1;
            List printedCycleStatesMaps = BddUtils.bddToStates((BDD)curStates, (CifBddSpec)cifBddSpec, (boolean)false, (int)askedPrintedCycleStatesCount);
            termination.throwIfRequested();
            boolean bl = complete = printedCycleStatesMaps.size() < askedPrintedCycleStatesCount;
            if (!complete) {
                printedCycleStatesMaps = Lists.slice((List)printedCycleStatesMaps, (Integer)0, (Integer)-1);
            }
            List printCycleStatesTxts = (List)printedCycleStatesMaps.stream().map(s -> BddUtils.stateToStr((Map)s, (String)"(empty state; no variables)")).collect(Lists.toList());
            termination.throwIfRequested();
            if (!complete) {
                printCycleStatesTxts.add("...");
            }
            result = new Bound(true, false, null, enabledEdgesTexts, printCycleStatesTxts);
        }
        curStates.free();
        return result;
    }
}

