/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.cif2cif.SimplifyValues;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEdgeUtils;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifUpdateUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.cif.metamodel.java.CifWithArgWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ElimStateInvs
implements CifToCifTransformation {
    private final StateObjectsCollector stateObjectsCollector = new StateObjectsCollector();
    private final StateObjectsReplacer stateObjectsReplacer = new StateObjectsReplacer(this.stateObjectsCollector);
    private final InitialValuesObtainer initialValuesObtainer = new InitialValuesObtainer();
    private final Set<SupKind> stateInvKindsToTransform;

    public ElimStateInvs() {
        this(EnumSet.of(SupKind.NONE, SupKind.PLANT, SupKind.SUPERVISOR));
    }

    public ElimStateInvs(Set<SupKind> stateInvKindsToTransform) {
        this.stateInvKindsToTransform = Collections.unmodifiableSet(stateInvKindsToTransform);
        Assert.check((!stateInvKindsToTransform.contains(SupKind.REQUIREMENT) ? 1 : 0) != 0);
    }

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            throw new CifToCifPreconditionException("Eliminating state invariants for a CIF specification with component definitions is currently not supported.");
        }
        List automata = (List)CifCollectUtils.collectAutomata((ComplexComponent)spec, (Collection)Lists.list());
        List alphabets = CifEventUtils.getAlphabets((List)automata);
        List events = (List)CifCollectUtils.collectEvents((ComplexComponent)spec, (Collection)Lists.list());
        for (Event event : events) {
            long count = alphabets.stream().filter(alphabet -> alphabet.contains(event)).count();
            if (count <= 1L) continue;
            throw new CifToCifPreconditionException(Strings.fmt((String)"Eliminating state invariants for a CIF specification with a synchronizing event (an event in the alphabet of multiple automata) is currently not supported (event \"%s\" is in the alphabet of %,d automata).", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event), count}));
        }
        for (IoDecl ioDecl : (List)CifCollectUtils.collectIoDeclarations((ComplexComponent)spec, (Collection)Lists.list())) {
            SvgIn svgIn;
            if (!(ioDecl instanceof SvgIn) || (svgIn = (SvgIn)ioDecl).getUpdates().isEmpty()) continue;
            throw new CifToCifPreconditionException("Eliminating state invariants for a CIF specification with SVG input mappings with updates is currently not supported.");
        }
        for (Automaton aut : automata) {
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    if (CifUpdateUtils.hasTupleAddressable((List)edge.getUpdates())) {
                        throw new CifToCifPreconditionException("Eliminating state invariants for a CIF specification with multi-assignments on edges is currently not supported.");
                    }
                    if (!CifUpdateUtils.hasProjectedAddressable((List)edge.getUpdates())) continue;
                    throw new CifToCifPreconditionException("Eliminating state invariants for a CIF specification with partial-variable assignments on edges is currently not supported.");
                }
            }
        }
        List<Invariant> stateInvs = (List<Invariant>)CifCollectUtils.collectInvariants((ComplexComponent)spec, (Collection)Lists.list());
        stateInvs = stateInvs.stream().filter(i -> i.getInvKind() == InvKind.STATE).toList();
        for (Invariant stateInv : stateInvs) {
            if (!CifValueUtils.isTimeConstant((Expression)stateInv.getPredicate(), (Boolean)true)) {
                throw new CifToCifPreconditionException("Eliminating state invariants for a CIF specification with time-dependent state invariants is currently not supported.");
            }
            if (CifValueUtils.isTimeConstant((Expression)stateInv.getPredicate(), (Boolean)false)) continue;
            throw new CifToCifPreconditionException("Eliminating state invariants for a CIF specification with state invariants that rely on the values of input variables is currently not supported.");
        }
        for (Invariant stateInv : stateInvs) {
            Predicate<Expression> isAutRef = expr -> {
                ComponentExpression cexpr;
                return expr instanceof SelfExpression || expr instanceof ComponentExpression && CifTypeUtils.isAutRefExpr((Expression)(cexpr = (ComponentExpression)expr));
            };
            if (!CifValueUtils.hasSubExprSatisfyingPred((Expression)stateInv.getPredicate(), isAutRef)) continue;
            throw new CifToCifPreconditionException("Eliminating state invariants for a CIF specification with state invariants that directly or indirectly contain a component (self) reference is currently not supported.");
        }
        stateInvs = stateInvs.stream().filter(i -> this.stateInvKindsToTransform.contains(i.getSupKind())).toList();
        List discVars = (List)CifCollectUtils.collectDiscVariables((ComplexComponent)spec, (Collection)Lists.list());
        List contVars = (List)CifCollectUtils.collectContVariables((ComplexComponent)spec, (Collection)Lists.list());
        for (PositionObject stateObj : Lists.concat((List[])new List[]{discVars, contVars, automata})) {
            this.initialValuesObtainer.get(stateObj);
        }
        for (Invariant stateInv : stateInvs) {
            if (stateInv.eContainer() instanceof Location) {
                this.adaptLocStateInv(stateInv);
            }
            this.addInit(spec, stateInv);
            this.addEdgeGuards(automata, stateInv);
            EMFHelper.removeFromParentContainment((EObject)stateInv);
        }
    }

    private void adaptLocStateInv(Invariant locStateInv) {
        Location loc = (Location)locStateInv.eContainer();
        Automaton aut = CifLocationUtils.getAutomaton((Location)loc);
        if (aut.getLocations().size() > 1) {
            BinaryExpression implExpr = CifConstructors.newBinaryExpression();
            implExpr.setOperator(BinaryOperator.IMPLICATION);
            implExpr.setLeft((Expression)CifConstructors.newLocationExpression((Location)loc, null, (CifType)CifConstructors.newBoolType()));
            implExpr.setRight(locStateInv.getPredicate());
            implExpr.setType((CifType)CifConstructors.newBoolType());
            locStateInv.setPredicate((Expression)implExpr);
        }
        aut.getInvariants().add((Object)locStateInv);
    }

    private void addInit(Specification spec, Invariant stateInv) {
        Set<PositionObject> occurringObjs = this.stateObjectsCollector.collect(stateInv.getPredicate());
        Map replacements = Maps.mapc((int)occurringObjs.size());
        for (PositionObject occurringObj : occurringObjs) {
            Expression initValue = this.initialValuesObtainer.get(occurringObj);
            if (initValue == null) continue;
            replacements.put(occurringObj, initValue);
        }
        Expression replacedPred = (Expression)EMFHelper.deepclone((EObject)stateInv.getPredicate());
        if (!occurringObjs.isEmpty()) {
            replacedPred = this.stateObjectsReplacer.replace(replacedPred, replacements);
        }
        if (CifValueUtils.isTriviallyTrue((Expression)replacedPred, (boolean)true, (boolean)true)) {
            return;
        }
        replacedPred = new SimplifyValues().transform(replacedPred);
        ComplexComponent parent = (ComplexComponent)stateInv.eContainer();
        parent.getInitials().add((Object)replacedPred);
    }

    private void addEdgeGuards(List<Automaton> automata, Invariant stateInv) {
        for (Automaton aut : automata) {
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    this.addEdgeGuards(edge, aut, stateInv);
                }
            }
        }
    }

    private void addEdgeGuards(Edge edge, Automaton aut, Invariant stateInv) {
        Set<PositionObject> occurringObjs;
        Map varToNewValueExpr;
        try {
            varToNewValueExpr = CifUpdateUtils.updatesToNewValueExprPerVar((List)edge.getUpdates());
        }
        catch (CifUpdateUtils.UnsupportedUpdateException e) {
            throw new AssertionError((Object)"Precondition violation.");
        }
        LinkedHashMap objToNewValueExpr = Maps.copy((Map)varToNewValueExpr);
        Location targetLoc = CifEdgeUtils.getTarget((Edge)edge);
        if (aut.getLocations().size() > 1) {
            LocationExpression targetRef = CifConstructors.newLocationExpression((Location)targetLoc, null, (CifType)CifConstructors.newBoolType());
            objToNewValueExpr.put(aut, targetRef);
        }
        if (Sets.isEmptyIntersection(occurringObjs = this.stateObjectsCollector.collect(stateInv.getPredicate()), objToNewValueExpr.keySet())) {
            return;
        }
        Expression extraGuard = (Expression)EMFHelper.deepclone((EObject)stateInv.getPredicate());
        if (CifValueUtils.isTriviallyTrue((Expression)(extraGuard = this.stateObjectsReplacer.replace(extraGuard, objToNewValueExpr)), (boolean)false, (boolean)true)) {
            return;
        }
        extraGuard = new SimplifyValues().transform(extraGuard);
        edge.getGuards().add((Object)extraGuard);
    }

    private static class InitialValuesObtainer {
        private static final Expression NO_VALUE = CifValueUtils.makeFalse();
        private final Map<PositionObject, Expression> cache = Maps.map();

        private InitialValuesObtainer() {
        }

        Expression get(PositionObject stateObj) {
            Expression initValue = this.cache.get(stateObj);
            if (initValue != null) {
                return initValue == NO_VALUE ? null : initValue;
            }
            if (stateObj instanceof DiscVariable) {
                DiscVariable discVar = (DiscVariable)stateObj;
                if (discVar.getValue() == null) {
                    List funcs = Lists.listc((int)0);
                    Expression defaultValue = CifValueUtils.getDefaultValue((CifType)discVar.getType(), (List)funcs);
                    if (funcs.isEmpty()) {
                        initValue = defaultValue;
                    }
                } else if (discVar.getValue().getValues().size() == 1) {
                    initValue = (Expression)discVar.getValue().getValues().get(0);
                }
            } else if (stateObj instanceof ContVariable) {
                ContVariable contVar = (ContVariable)stateObj;
                initValue = contVar.getValue() == null ? CifValueUtils.makeReal((double)0.0) : contVar.getValue();
            } else if (stateObj instanceof Automaton) {
                Automaton aut = (Automaton)stateObj;
                for (Location loc : aut.getLocations()) {
                    if (loc.getName() == null) {
                        initValue = null;
                    } else {
                        boolean isInitLoc;
                        boolean isNotInitLoc;
                        EList initPreds = loc.getInitials();
                        boolean bl = isNotInitLoc = initPreds.isEmpty() || CifValueUtils.isTriviallyFalse((List)initPreds, (boolean)true, (boolean)true);
                        if (isNotInitLoc) continue;
                        boolean bl2 = isInitLoc = !initPreds.isEmpty() && CifValueUtils.isTriviallyTrue((List)initPreds, (boolean)true, (boolean)true);
                        if (isInitLoc) {
                            if (initValue == null) {
                                initValue = CifConstructors.newLocationExpression((Location)loc, null, (CifType)CifConstructors.newBoolType());
                                continue;
                            }
                            initValue = null;
                        } else {
                            initValue = null;
                        }
                    }
                    break;
                }
            } else {
                throw new AssertionError((Object)("Unexpected state object: " + String.valueOf(stateObj)));
            }
            if (initValue == null) {
                initValue = NO_VALUE;
            }
            this.cache.put(stateObj, initValue);
            return initValue == NO_VALUE ? null : initValue;
        }
    }

    private static class StateObjectsCollector
    extends CifWithArgWalker<Set<PositionObject>> {
        private Map<ContVariable, Set<PositionObject>> derivCache = Maps.map();
        private Map<AlgVariable, Set<PositionObject>> algCache = Maps.map();

        private StateObjectsCollector() {
        }

        Set<PositionObject> collect(Expression expr) {
            Set objects = Sets.setc((int)1);
            this.walkExpression(expr, objects);
            return objects;
        }

        protected void preprocessLocationExpression(LocationExpression locRef, Set<PositionObject> objects) {
            Location loc = locRef.getLocation();
            Automaton aut = CifLocationUtils.getAutomaton((Location)loc);
            objects.add((PositionObject)aut);
        }

        protected void preprocessDiscVariableExpression(DiscVariableExpression varRef, Set<PositionObject> objects) {
            objects.add((PositionObject)varRef.getVariable());
        }

        protected void preprocessContVariableExpression(ContVariableExpression varRef, Set<PositionObject> objects) {
            if (varRef.isDerivative()) {
                ContVariable contVar = varRef.getVariable();
                Set derivObjs = this.derivCache.get(contVar);
                if (derivObjs == null) {
                    derivObjs = Sets.setc((int)1);
                    Expression deriv = CifEquationUtils.getSingleDerivativeForContVar((ContVariable)contVar);
                    this.walkExpression(deriv, derivObjs);
                    this.derivCache.put(contVar, derivObjs);
                }
                objects.addAll(derivObjs);
            } else {
                objects.add((PositionObject)varRef.getVariable());
            }
        }

        protected void walkAlgVariableExpression(AlgVariableExpression varRef, Set<PositionObject> objects) {
            AlgVariable algVar = varRef.getVariable();
            Set algObjs = this.algCache.get(algVar);
            if (algObjs == null) {
                algObjs = Sets.setc((int)1);
                Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)algVar);
                this.walkExpression(value, algObjs);
                this.algCache.put(algVar, algObjs);
            }
            objects.addAll(algObjs);
        }

        protected void preprocessComponentExpression(ComponentExpression compRef, Set<PositionObject> objects) {
            throw new AssertionError((Object)("Precondition violation: " + String.valueOf(compRef)));
        }

        protected void preprocessSelfExpression(SelfExpression selfRef, Set<PositionObject> objects) {
            throw new AssertionError((Object)("Precondition violation: " + String.valueOf(selfRef)));
        }
    }

    private static class StateObjectsReplacer
    extends CifWalker {
        private final Invariant dummyInv = CifConstructors.newInvariant();
        private final StateObjectsCollector stateObjectsCollector;
        private Map<PositionObject, Expression> replacements;

        StateObjectsReplacer(StateObjectsCollector stateObjectsCollector) {
            this.stateObjectsCollector = stateObjectsCollector;
        }

        Expression replace(Expression expr, Map<PositionObject, Expression> replacements) {
            this.replacements = replacements;
            this.dummyInv.setPredicate(expr);
            this.walkExpression(expr);
            Expression rslt = this.dummyInv.getPredicate();
            this.dummyInv.setPredicate(null);
            this.replacements = null;
            Assert.notNull((Object)rslt);
            return rslt;
        }

        protected void preprocessLocationExpression(LocationExpression locRef) {
            Location loc = locRef.getLocation();
            Automaton aut = CifLocationUtils.getAutomaton((Location)loc);
            Expression replacement = this.replacements.get(aut);
            if (replacement != null) {
                Location replacementLoc = ((LocationExpression)replacement).getLocation();
                EMFHelper.updateParentContainment((EObject)locRef, (EObject)CifValueUtils.makeBool((loc == replacementLoc ? 1 : 0) != 0));
            }
        }

        protected void preprocessDiscVariableExpression(DiscVariableExpression varRef) {
            DiscVariable discVar = varRef.getVariable();
            Expression replacement = this.replacements.get(discVar);
            if (replacement != null) {
                EMFHelper.updateParentContainment((EObject)varRef, (EObject)EMFHelper.deepclone((EObject)replacement));
            }
        }

        protected void preprocessContVariableExpression(ContVariableExpression varRef) {
            if (varRef.isDerivative()) {
                ContVariable contVar = varRef.getVariable();
                Set<PositionObject> derivStateObjs = this.stateObjectsCollector.collect((Expression)varRef);
                if (Sets.isEmptyIntersection(derivStateObjs, this.replacements.keySet())) {
                    return;
                }
                Expression deriv = (Expression)EMFHelper.deepclone((EObject)CifEquationUtils.getSingleDerivativeForContVar((ContVariable)contVar));
                EMFHelper.updateParentContainment((EObject)varRef, (EObject)deriv);
                this.walkExpression(deriv);
            } else {
                ContVariable contVar = varRef.getVariable();
                Expression replacement = this.replacements.get(contVar);
                if (replacement != null) {
                    EMFHelper.updateParentContainment((EObject)varRef, (EObject)EMFHelper.deepclone((EObject)replacement));
                }
            }
        }

        protected void walkAlgVariableExpression(AlgVariableExpression varRef) {
            AlgVariable algVar = varRef.getVariable();
            Set<PositionObject> algStateObjs = this.stateObjectsCollector.collect((Expression)varRef);
            if (Sets.isEmptyIntersection(algStateObjs, this.replacements.keySet())) {
                return;
            }
            Expression value = (Expression)EMFHelper.deepclone((EObject)CifEquationUtils.getSingleValueForAlgVar((AlgVariable)algVar));
            EMFHelper.updateParentContainment((EObject)varRef, (EObject)value);
            this.walkExpression(value);
        }

        protected void preprocessComponentExpression(ComponentExpression compRef) {
            throw new AssertionError((Object)("Precondition violation: " + String.valueOf(compRef)));
        }

        protected void preprocessSelfExpression(SelfExpression selfRef) {
            throw new AssertionError((Object)("Precondition violation: " + String.valueOf(selfRef)));
        }
    }
}

