/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeUtils {
    private DateTimeUtils() {
    }

    public static String formatDateTime(Date dateTime, boolean utc) {
        return DateTimeUtils.formatDateTime(dateTime, utc, false);
    }

    public static String formatDateTime(Date dateTime, boolean utc, boolean includeTimeZone) {
        Object fmt = "yyyy-MM-dd HH:mm:ss.SSS";
        if (includeTimeZone) {
            fmt = (String)fmt + " z (Z)";
        }
        SimpleDateFormat df = new SimpleDateFormat((String)fmt, Locale.US);
        if (utc) {
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return df.format(dateTime);
    }

    public static String formatDateTime(long dateTime, boolean utc) {
        return DateTimeUtils.formatDateTime(dateTime, utc, false);
    }

    public static String formatDateTime(long dateTime, boolean utc, boolean includeTimeZone) {
        return DateTimeUtils.formatDateTime(new Date(dateTime), utc, includeTimeZone);
    }

    public static String durationToString(long duration, boolean omitZero) {
        long x = duration;
        long ms = x % 1000L;
        long s = (x /= 1000L) % 60L;
        long m = (x /= 60L) % 60L;
        long h = x /= 60L;
        StringBuilder rslt = new StringBuilder();
        if (h != 0L || !omitZero) {
            rslt.append(h + "h");
        }
        if (m != 0L || !omitZero) {
            if (rslt.length() > 0) {
                rslt.append(" ");
            }
            rslt.append(m + "m");
        }
        if (s != 0L || !omitZero) {
            if (rslt.length() > 0) {
                rslt.append(" ");
            }
            rslt.append(s + "s");
        }
        if (ms != 0L || !omitZero || duration == 0L) {
            if (rslt.length() > 0) {
                rslt.append(" ");
            }
            rslt.append(ms + "ms");
        }
        return rslt.toString();
    }

    public static long nanoTimeToMillis(long nanoTime) {
        return (long)((double)nanoTime / 1000000.0);
    }
}

