/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.generator.scanner;

import java.util.Map;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.setext.generator.scanner.AutomatonState;

public class Automaton {
    public final AutomatonState initialState;
    public int nextStateId = 0;
    public final Map<AutomatonState, AutomatonState> states = Maps.map();

    public Automaton(AutomatonState initialState) {
        this.initialState = initialState;
        this.addState(initialState);
    }

    public AutomatonState addState(AutomatonState state) {
        if (this.states.containsKey(state)) {
            return this.states.get(state);
        }
        this.states.put(state, state);
        state.id = this.nextStateId++;
        return state;
    }

    public void print(AppStream s) {
        int id = 0;
        for (AutomatonState state : this.states.keySet()) {
            Assert.check((state.id == id ? 1 : 0) != 0);
            ++id;
            s.println();
            state.print(s, state == this.initialState);
        }
    }
}

