/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.distributions;

import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.distributions.CifRandomGenerator;
import org.eclipse.escet.cif.simulator.runtime.distributions.NormalDistribution;
import org.eclipse.escet.cif.simulator.runtime.distributions.RealDistribution;
import org.eclipse.escet.common.java.Strings;

public class LogNormalDistribution
extends NormalDistribution {
    public LogNormalDistribution(CifRandomGenerator randGen, double mean, double variance) {
        super(randGen, mean, LogNormalDistribution.checkVariance(mean, variance));
    }

    private static double checkVariance(double mean, double variance) {
        if (variance <= 0.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: lognormal(%s, %s).", (Object[])new Object[]{CifSimulatorMath.realToStr(mean), CifSimulatorMath.realToStr(variance)});
            String msg2 = "The variance parameter (the second parameter) is not positive.";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
        return variance;
    }

    private LogNormalDistribution(LogNormalDistribution distribution) {
        super(distribution);
    }

    @Override
    public RealDistribution copy() {
        return new LogNormalDistribution(this);
    }

    @Override
    public double sample() {
        return Math.exp(super.sample());
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"lognormal(%s, %s)", (Object[])new Object[]{CifSimulatorMath.realToStr(this.mean), CifSimulatorMath.realToStr(this.variance)});
    }
}

