/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.builder;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.publisher.eclipse.IPlatformEntry;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.builder.DevClassPathHelper;

public abstract class AbstractBuildScriptGenerator
extends AbstractScriptGenerator {
    protected DevClassPathHelper devEntries;
    protected AssemblyInformation assemblyData;
    protected Properties buildProperties;
    private Set<String> compiledElements;
    private boolean includePlatformIndependent = true;
    private boolean ignoreMissingPropertiesFile = true;
    private static Properties executionEnvironmentMappings = null;

    protected abstract Properties getBuildProperties() throws CoreException;

    public static Properties getExecutionEnvironmentMappings() {
        if (executionEnvironmentMappings != null) {
            return executionEnvironmentMappings;
        }
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream stream = BundleHelper.getDefault().getBundle().getEntry("data/env.properties").openStream();){
                properties.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        executionEnvironmentMappings = properties;
        return executionEnvironmentMappings;
    }

    public void setDevEntries(Path entries) {
        this.devEntries = new DevClassPathHelper(entries);
    }

    public void setDevEntries(DevClassPathHelper entries) {
        this.devEntries = entries;
    }

    public void includePlatformIndependent(boolean value) {
        this.includePlatformIndependent = value;
    }

    public boolean isPlatformIndependentIncluded() {
        return this.includePlatformIndependent;
    }

    public List<Config> selectConfigs(IPlatformEntry element) {
        Config config;
        Iterator iter;
        ArrayList<Config> result = new ArrayList<Config>(AbstractBuildScriptGenerator.getConfigInfos());
        if (!(element.getOS() != null && !element.getOS().equals(Config.ANY) || this.includePlatformIndependent || element.getWS() != null && !element.getWS().equals(Config.ANY) || this.includePlatformIndependent || element.getArch() != null && !element.getArch().equals(Config.ANY) || this.includePlatformIndependent)) {
            result.clear();
            return result;
        }
        if (element.getOS() != null && !element.getOS().equals(Config.ANY)) {
            iter = result.iterator();
            while (iter.hasNext()) {
                config = (Config)iter.next();
                if (this.isMatching(element.getOS(), config.getOs())) continue;
                iter.remove();
            }
        }
        if (element.getWS() != null && !element.getWS().equals(Config.ANY)) {
            iter = result.iterator();
            while (iter.hasNext()) {
                config = (Config)iter.next();
                if (this.isMatching(element.getWS(), config.getWs())) continue;
                iter.remove();
            }
        }
        if (element.getArch() != null && !element.getArch().equals(Config.ANY)) {
            iter = result.iterator();
            while (iter.hasNext()) {
                config = (Config)iter.next();
                if (this.isMatching(element.getArch(), config.getArch())) continue;
                iter.remove();
            }
        }
        return result;
    }

    private boolean isMatching(String candidateValues, String configValue) {
        StringTokenizer stok = new StringTokenizer(candidateValues, ",");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken().toUpperCase();
            if (!configValue.equalsIgnoreCase(token)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getCompiledElements() {
        if (this.compiledElements == null) {
            this.compiledElements = new HashSet<String>();
        }
        return this.compiledElements;
    }

    public void setCompiledElements(Set<String> compiledElements) {
        this.compiledElements = compiledElements;
    }

    public void setReportResolutionErrors(boolean value) {
        this.reportResolutionErrors = value;
    }

    public boolean isIgnoreMissingPropertiesFile() {
        if (BundleHelper.getDefault().isDebugging()) {
            return false;
        }
        return this.ignoreMissingPropertiesFile;
    }

    public void setIgnoreMissingPropertiesFile(boolean value) {
        this.ignoreMissingPropertiesFile = value;
    }
}

