/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.random.DoubleDistribution;
import org.eclipse.escet.chi.runtime.data.random.GammaDistribution;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.java.Strings;

public class BetaDistribution
extends DoubleDistribution {
    private RandomGenerator randGen1;
    private RandomGenerator randGen2;
    private RandomGenerator randGen3;
    private RandomGenerator randGen4;
    private double p;
    private double q;

    public BetaDistribution(ChiCoordinator chiCoordinator, double p, double q) {
        super(chiCoordinator);
        if (p <= 0.0) {
            String msg = Strings.fmt((String)"The Beta distribution expects a shape parameter p bigger than 0, found %s instead.", (Object[])new Object[]{p});
            throw new ChiSimulatorException(msg);
        }
        if (q <= 0.0) {
            String msg = Strings.fmt((String)"The Beta distribution expects a shape parameter q bigger than 0, found %s instead.", (Object[])new Object[]{q});
            throw new ChiSimulatorException(msg);
        }
        this.p = p;
        this.q = q;
        this.randGen1 = chiCoordinator.getFreshGenerator();
        this.randGen2 = chiCoordinator.getFreshGenerator();
        this.randGen3 = chiCoordinator.getFreshGenerator();
        this.randGen4 = chiCoordinator.getFreshGenerator();
    }

    @Override
    public double sample() {
        return BetaDistribution.drawBeta(this.randGen1, this.randGen2, this.randGen3, this.randGen4, this.p, this.q);
    }

    public static double drawBeta(RandomGenerator randGen1, RandomGenerator randGen2, RandomGenerator randGen3, RandomGenerator randGen4, double p, double q) {
        double g1 = GammaDistribution.drawGamma(randGen1, randGen2, p, 1.0);
        double g2 = GammaDistribution.drawGamma(randGen3, randGen4, q, 1.0);
        return g1 / (g1 + g2);
    }
}

